/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.types;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;

public final class ByteString
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Charset UTF8 = Charset.forName("UTF-8");
    public static final ByteString EMPTY = ByteString.b("");
    private byte[] bytes;
    private transient int hashVal;

    public ByteString(String str) {
        this.bytes = str.getBytes();
    }

    public ByteString(String str, int length) {
        this.bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            this.bytes[i] = (byte)str.charAt(i);
        }
    }

    public ByteString(byte[] bytes) {
        this.bytes = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.bytes, 0, bytes.length);
    }

    public ByteString(byte[] bytes, int length) {
        this.bytes = new byte[length];
        System.arraycopy(bytes, 0, this.bytes, 0, length);
    }

    public ByteString(byte[] bytes, int from, int to) {
        this.bytes = new byte[to - from];
        System.arraycopy(bytes, from, this.bytes, 0, to - from);
    }

    private ByteString() {
    }

    public int length() {
        return this.bytes.length;
    }

    public String toString() {
        return new String(this.bytes, UTF8);
    }

    public boolean startsWith(String string) {
        int l = string.length();
        if (this.bytes.length < l) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if ((byte)string.charAt(i) == this.bytes[i]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String string) {
        int l = string.length();
        if (this.bytes.length < l) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            char c = string.charAt(i);
            if ((byte)c == this.bytes[i] || Character.toLowerCase(c) == Character.toLowerCase(this.bytes[i] & 0xFF)) continue;
            return false;
        }
        return true;
    }

    public ByteString substring(int beginIndex, int endIndex) {
        ByteString bs = new ByteString();
        bs.bytes = new byte[endIndex - beginIndex];
        System.arraycopy(this.bytes, beginIndex, bs.bytes, 0, endIndex - beginIndex);
        return bs;
    }

    public void copyTo(int beginIndex, int endIndex, byte[] dest, int offset) {
        System.arraycopy(this.bytes, beginIndex, dest, offset, endIndex - beginIndex);
    }

    public boolean isPrefixOf(String string) {
        if (this.bytes.length > string.length()) {
            return false;
        }
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(String string) {
        return this.indexOf(string) != -1;
    }

    public ByteString trimmedSubstring(int from, int to) {
        byte[] sub = new byte[to - from];
        int bytesW = 0;
        for (int i = from; i < to; ++i) {
            byte b = this.bytes[i];
            if (b == 32 || b == 9 || b == 10 || b == 13) continue;
            sub[bytesW] = b;
            ++bytesW;
        }
        if (to - from != bytesW) {
            return new ByteString(sub, bytesW);
        }
        ByteString bs = new ByteString();
        bs.bytes = sub;
        return bs;
    }

    public int indexOf(ByteString string) {
        byte[] stringBytes = string.bytes;
        for (int i = 0; i < this.bytes.length; ++i) {
            int j;
            if (i + stringBytes.length > this.bytes.length) {
                return -1;
            }
            if (stringBytes[0] != this.bytes[i]) continue;
            for (j = 1; j < stringBytes.length && stringBytes[j] == this.bytes[j + i]; ++j) {
            }
            if (j != stringBytes.length) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(String string) {
        byte[] stringBytes = string.getBytes();
        for (int i = 0; i < this.bytes.length; ++i) {
            int j;
            if (i + stringBytes.length > this.bytes.length) {
                return -1;
            }
            if (stringBytes[0] != this.bytes[i]) continue;
            for (j = 1; j < stringBytes.length && stringBytes[j] == this.bytes[j + i]; ++j) {
            }
            if (j != stringBytes.length) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteString) {
            ByteString bStr = (ByteString)obj;
            if (bStr.bytes.length != this.bytes.length) {
                return false;
            }
            for (int i = 0; i < this.bytes.length; ++i) {
                if (this.bytes[i] == bStr.bytes[i]) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.length() != this.bytes.length) {
                return false;
            }
            for (int i = 0; i < this.bytes.length; ++i) {
                if (str.charAt(i) == this.bytes[i]) continue;
                return false;
            }
            return true;
        }
        return this.equals(obj);
    }

    public int hashCode() {
        if (this.hashVal != 0) {
            return this.hashVal;
        }
        for (int i = 0; i < this.bytes.length; ++i) {
            this.hashVal = 31 * this.hashVal + this.bytes[i];
        }
        return this.hashVal;
    }

    public ByteString[] split(byte c) {
        ByteString bs;
        int to;
        int from = 0;
        ArrayList<ByteString> bl = new ArrayList<ByteString>();
        for (to = 0; to < this.bytes.length; ++to) {
            if (this.bytes[to] != c) continue;
            bs = new ByteString(this.bytes, from, to);
            bl.add(bs);
            from = to + 1;
        }
        bs = new ByteString(this.bytes, from, to);
        bl.add(bs);
        ByteString[] bsArray = new ByteString[bl.size()];
        bl.toArray(bsArray);
        return bsArray;
    }

    public static int parseFirstInt(byte[] buf, int off, int len) {
        int number = 0;
        boolean converting = false;
        for (int i = off; i < off + len; ++i) {
            byte b = buf[i];
            if (b >= 48 && b <= 57) {
                number *= 10;
                number += b - 48;
                converting = true;
                continue;
            }
            if (converting) break;
        }
        if (!converting) {
            throw new NumberFormatException();
        }
        return number;
    }

    public static int parseFirstInt(ByteString byteString) {
        return ByteString.parseFirstInt(byteString.bytes, 0, byteString.length());
    }

    public int compareTo(ByteString name) {
        return this.toString().compareTo(name.toString());
    }

    public static ByteString b(String str) {
        return new ByteString(str);
    }

    public static String toString(ByteString bStr) {
        if (bStr == null) {
            return null;
        }
        return bStr.toString();
    }
}

