/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.ontology;

import java.io.Serializable;
import java.util.HashMap;
import ontologizer.ontology.Prefix;
import ontologizer.ontology.PrefixPool;
import ontologizer.types.ByteString;
import ontologizer.util.Util;

public class TermID
implements Comparable<TermID>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Prefix DEFAULT_PREFIX = new Prefix("GO");
    public static final ByteString COLON = new ByteString(":");
    private final Prefix prefix;
    public final int id;
    private static final HashMap<String, Integer> string2id = new HashMap();
    private static int nextId = Integer.MAX_VALUE;

    public TermID(int id) {
        this.id = id;
        this.prefix = DEFAULT_PREFIX;
    }

    public TermID(Prefix prefix, int id) {
        this.id = id;
        this.prefix = prefix;
    }

    public TermID(String stringID) {
        this(stringID, null);
    }

    public TermID(String stringID, PrefixPool prefixPool) {
        int parsedId;
        int colon = stringID.indexOf(58);
        if (colon < 1) {
            throw new IllegalArgumentException("Failed to find a proper prefix of termid: \"" + stringID + "\"");
        }
        Prefix newPrefix = new Prefix(stringID, colon);
        this.prefix = prefixPool != null ? prefixPool.map(newPrefix) : newPrefix;
        String parseIdFrom = stringID.substring(colon + 1);
        try {
            parsedId = Integer.parseInt(parseIdFrom);
        }
        catch (NumberFormatException ex) {
            parsedId = this.makeIdFromString(parseIdFrom);
        }
        this.id = parsedId;
    }

    public TermID(ByteString stringID, PrefixPool prefixPool) {
        int colon = stringID.indexOf(COLON);
        if (colon < 1) {
            throw new IllegalArgumentException("Failed to find a proper prefix of termid: \"" + stringID.toString() + "\"");
        }
        Prefix newPrefix = new Prefix(stringID.substring(0, colon));
        this.prefix = prefixPool != null ? prefixPool.map(newPrefix) : newPrefix;
        try {
            int parsedId;
            this.id = parsedId = ByteString.parseFirstInt(stringID);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Failed to parse the integer part of termid: \"" + stringID.toString() + "\"");
        }
    }

    public TermID(byte[] id, int start, int len, PrefixPool prefixPool) {
        int tid;
        int colon = -1;
        for (int i = start; i < start + len; ++i) {
            if (id[i] != 58) continue;
            colon = i;
            break;
        }
        if (colon < 1) {
            throw new IllegalArgumentException("Failed to find a proper prefix of termid: \"" + new String(id, start, len) + "\"");
        }
        Prefix newPrefix = new Prefix(new ByteString(id, start, colon));
        this.prefix = prefixPool != null ? prefixPool.map(newPrefix) : newPrefix;
        try {
            tid = ByteString.parseFirstInt(id, colon, start + len - colon);
        }
        catch (NumberFormatException ex) {
            String strID = new String(id, colon + 1, start + len - colon - 1);
            tid = this.makeIdFromString(strID);
        }
        this.id = tid;
    }

    private int makeIdFromString(String id) {
        if (string2id.containsKey(id)) {
            return string2id.get(id);
        }
        string2id.put(id, --nextId);
        return nextId;
    }

    public Prefix getPrefix() {
        return this.prefix;
    }

    public String toString() {
        String idString = Integer.toString(this.id);
        StringBuffer buf = new StringBuffer(16);
        buf.append(this.prefix.toString());
        buf.append(":");
        for (int i = 0; i < 7 - idString.length(); ++i) {
            buf.append('0');
        }
        buf.append(idString);
        return buf.toString();
    }

    public ByteString toByteString() {
        ByteString prefixByteString = this.prefix.getByteString();
        int pl = prefixByteString.length();
        int idlen = Util.lengthOf(this.id);
        byte[] idBytes = new byte[pl + 1 + Math.max(7, idlen)];
        prefixByteString.copyTo(0, pl, idBytes, 0);
        idBytes[pl] = 58;
        if (idlen < 7) {
            for (int i = 0; i < 7 - idlen; ++i) {
                idBytes[i + pl + 1] = 48;
            }
            pl += 7 - idlen;
        }
        Util.intToByteArray(this.id, idBytes, pl + 1);
        return new ByteString(idBytes);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TermID) {
            TermID goTermID = (TermID)obj;
            if (goTermID.id != this.id) {
                return false;
            }
            return goTermID.prefix.equals(this.prefix);
        }
        return super.equals(obj);
    }

    public static TermID tid(String id) {
        return new TermID(id);
    }

    @Override
    public int compareTo(TermID o) {
        return this.id - o.id;
    }
}

