/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.ontology;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import ontologizer.ontology.Term;
import ontologizer.ontology.TermID;
import ontologizer.ontology.TermMap;
import ontologizer.types.ByteString;

public class TermContainer
extends TermMap
implements Iterable<Term>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<Term> termList;
    private ByteString formatVersion;
    private ByteString date;

    public TermContainer(Iterable<Term> terms, ByteString format, ByteString datum) {
        super(terms);
        this.formatVersion = format;
        this.date = datum;
        int initialCapacity = 100;
        if (terms instanceof Collection) {
            initialCapacity = ((Collection)terms).size();
        }
        this.termList = new ArrayList<Term>(initialCapacity);
        for (Term entry : terms) {
            this.termList.add(entry);
        }
    }

    public int termCount() {
        return this.termList.size();
    }

    public ByteString getFormatVersion() {
        return this.formatVersion;
    }

    public ByteString getDate() {
        return this.date;
    }

    public String getName(String GOid) {
        Term got = this.get(GOid);
        if (got == null) {
            return null;
        }
        return got.getName().toString();
    }

    public String getName(TermID id) {
        Term got = this.get(id);
        if (got == null) {
            return null;
        }
        return got.getName().toString();
    }

    public Term get(String id) {
        TermID tempID = new TermID(id);
        return this.get(tempID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("*****\n---Term Container---\n*****\n");
        sb.append("gene_ontology.obo format-version " + this.getFormatVersion() + " from " + this.getDate() + " was parsed.\n");
        sb.append("A total of " + this.termCount() + " terms were identified.\n");
        return sb.toString();
    }

    @Override
    public Iterator<Term> iterator() {
        return this.termList.iterator();
    }
}

