/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.ontology;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ontologizer.ontology.ITerm;
import ontologizer.ontology.Namespace;
import ontologizer.ontology.ParentTermID;
import ontologizer.ontology.PrefixPool;
import ontologizer.ontology.Subset;
import ontologizer.ontology.TermID;
import ontologizer.ontology.TermXref;
import ontologizer.types.ByteString;

public class Term
implements ITerm,
Serializable {
    private static final long serialVersionUID = 1L;
    private TermID id;
    private ByteString name;
    private ByteString definition;
    private ParentTermID[] parents;
    private ArrayList<TermID> alternatives;
    private TermID[] equivalents;
    private ByteString[] synonyms;
    private String[] intersections;
    private static final Subset[] NO_SUBSETS = new Subset[0];
    private Subset[] subsets = NO_SUBSETS;
    private TermXref[] xrefs;
    private Namespace namespace;
    private boolean obsolete;
    private double informationContent = -1.0;

    private Term() {
    }

    public Term(TermID id, ByteString name, Namespace namespace, Collection<ParentTermID> parents) {
        this.init(id, name, namespace, parents);
    }

    public Term(TermID id, String name, Namespace namespace, Collection<ParentTermID> parents) {
        this.init(id, new ByteString(name), namespace, parents);
    }

    public Term(String strId, ByteString name, Namespace namespace, Collection<ParentTermID> parents) {
        this.init(new TermID(strId), name, namespace, parents);
    }

    public Term(String strId, String name, Namespace bNamespace, Collection<ParentTermID> rootlist) {
        this(new TermID(strId), new ByteString(name), bNamespace, rootlist);
    }

    public Term(TermID id, ByteString name, Namespace namespace, ParentTermID ... parents) {
        this.init(id, name, namespace, parents);
    }

    public Term(TermID id, ByteString name, ParentTermID ... parents) {
        this.init(id, name, null, parents);
    }

    public Term(String strId, ByteString name, ParentTermID ... parents) {
        this.init(new TermID(strId), name, null, parents);
    }

    public Term(String strId, String name, ParentTermID ... parents) {
        this(new TermID(strId), new ByteString(name), parents);
    }

    public Term(String strId, ByteString name, Namespace namespace, ParentTermID ... parents) {
        this.init(new TermID(strId), name, namespace, parents);
    }

    public Term(String strId, String name, Namespace namespace, ParentTermID ... parents) {
        this(new TermID(strId), new ByteString(name), namespace, parents);
    }

    private void init(TermID id, ByteString name, Namespace namespace, Collection<ParentTermID> parents) {
        ParentTermID[] parentArray = new ParentTermID[parents.size()];
        parents.toArray(parentArray);
        this.init(id, name, namespace, parentArray);
    }

    private void init(TermID id, ByteString name, Namespace namespace, ParentTermID[] parents) {
        this.id = id;
        this.name = name;
        this.parents = parents;
        if (namespace == null) {
            namespace = Namespace.UNKOWN_NAMESPACE;
        } else {
            this.namespace = namespace;
        }
    }

    public String getIDAsString() {
        return this.id.toString();
    }

    @Override
    public TermID getID() {
        return this.id;
    }

    @Override
    public ByteString getName() {
        return this.name;
    }

    @Override
    public Namespace getNamespace() {
        if (this.namespace == null) {
            return Namespace.UNKOWN_NAMESPACE;
        }
        return this.namespace;
    }

    @Override
    public ParentTermID[] getParents() {
        return this.parents;
    }

    public String toString() {
        return this.name + " (" + this.id.toString() + ")";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Term) {
            Term goTerm = (Term)obj;
            return goTerm.id.equals(this.id);
        }
        return super.equals(obj);
    }

    public void setObsolete(boolean currentObsolete) {
        this.obsolete = currentObsolete;
    }

    @Override
    public boolean isObsolete() {
        return this.obsolete;
    }

    @Override
    public ByteString getDefinition() {
        return this.definition;
    }

    public void setDefinition(ByteString definition) {
        this.definition = definition;
    }

    public void setEquivalents(ArrayList<TermID> currentEquivalents) {
        this.equivalents = new TermID[currentEquivalents.size()];
        int i = 0;
        for (TermID t : currentEquivalents) {
            this.equivalents[i++] = t;
        }
    }

    @Override
    public TermID[] getEquivalents() {
        return this.equivalents;
    }

    public void setAlternatives(List<TermID> altList) {
        this.alternatives = new ArrayList();
        this.alternatives.addAll(altList);
    }

    @Override
    public TermID[] getAlternatives() {
        TermID[] alts = new TermID[this.alternatives.size()];
        return this.alternatives.toArray(alts);
    }

    public void setSubsets(ArrayList<Subset> newSubsets) {
        this.subsets = new Subset[newSubsets.size()];
        newSubsets.toArray(this.subsets);
    }

    @Override
    public Subset[] getSubsets() {
        return this.subsets;
    }

    public void setSynonyms(ArrayList<ByteString> currentSynonyms) {
        if (currentSynonyms.size() > 0) {
            this.synonyms = new ByteString[currentSynonyms.size()];
            currentSynonyms.toArray(this.synonyms);
        }
    }

    @Override
    public ByteString[] getSynonyms() {
        return this.synonyms;
    }

    public void setXrefs(ArrayList<TermXref> currentXrefs) {
        if (currentXrefs.size() > 0) {
            this.xrefs = new TermXref[currentXrefs.size()];
            currentXrefs.toArray(this.xrefs);
        }
    }

    @Override
    public TermXref[] getXrefs() {
        return this.xrefs;
    }

    public void setIntersections(ArrayList<String> currentIntersections) {
        if (currentIntersections.size() > 0) {
            this.intersections = new String[currentIntersections.size()];
            currentIntersections.toArray(this.intersections);
        }
    }

    public void addAlternativeId(TermID id2) {
        if (this.alternatives == null) {
            this.alternatives = new ArrayList();
        }
        this.alternatives.add(id2);
    }

    public void setInformationContent(double informationContent) {
        this.informationContent = informationContent;
    }

    public double getInformationContent() {
        return this.informationContent;
    }

    public static RequiresName prefixPool(PrefixPool prefixPool) {
        TermBuilder builder = new TermBuilder();
        builder.prefixPool = prefixPool;
        return builder;
    }

    public static RequiresTermID name(String name) {
        return Term.name(new ByteString(name));
    }

    public static RequiresTermID name(ByteString name) {
        TermBuilder builder = new TermBuilder();
        ((TermBuilder)builder).term.name = name;
        return builder;
    }

    static /* synthetic */ ParentTermID[] access$402(Term x0, ParentTermID[] x1) {
        x0.parents = x1;
        return x1;
    }

    public static class TermBuilder
    implements RequiresName,
    RequiresTermID,
    Optional {
        private Term term = new Term();
        private PrefixPool prefixPool;

        @Override
        public RequiresTermID name(ByteString name) {
            this.term.name = name;
            return this;
        }

        @Override
        public RequiresTermID name(String name) {
            return this.name(new ByteString(name));
        }

        @Override
        public Optional id(String termID) {
            this.term.id = new TermID(termID, this.prefixPool);
            return this;
        }

        @Override
        public Optional id(TermID termID) {
            this.term.id = termID;
            return this;
        }

        @Override
        public Optional id(ByteString termID) {
            this.term.id = new TermID(termID, this.prefixPool);
            return this;
        }

        @Override
        public Optional definition(ByteString definition) {
            this.term.definition = definition;
            return this;
        }

        @Override
        public Optional parents(ParentTermID ... parents) {
            Term.access$402(this.term, parents);
            return this;
        }

        @Override
        public Optional obsolete(boolean obsolete) {
            this.term.obsolete = obsolete;
            return this;
        }

        @Override
        public Term build() {
            return this.term;
        }
    }

    public static interface RequiresTermID {
        public Optional id(String var1);

        public Optional id(ByteString var1);

        public Optional id(TermID var1);
    }

    public static interface RequiresName {
        public RequiresTermID name(ByteString var1);

        public RequiresTermID name(String var1);
    }

    public static interface Optional {
        public Optional definition(ByteString var1);

        public Optional parents(ParentTermID ... var1);

        public Optional obsolete(boolean var1);

        public Term build();
    }
}

