/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.ontology;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ontologizer.ontology.OntologyEdge;
import ontologizer.ontology.ParentTermID;
import ontologizer.ontology.Subset;
import ontologizer.ontology.Term;
import ontologizer.ontology.TermContainer;
import ontologizer.ontology.TermID;
import ontologizer.ontology.TermMap;
import ontologizer.ontology.TermRelation;
import sonumina.math.graph.AbstractGraph;
import sonumina.math.graph.DirectedGraph;
import sonumina.math.graph.Edge;
import sonumina.math.graph.SlimDirectedGraphView;

public class Ontology
implements Iterable<Term>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(Ontology.class.getName());
    private static HashSet<String> level1TermNames = new HashSet<String>(Arrays.asList("molecular_function", "biological_process", "cellular_component"));
    private DirectedGraph<Term> graph;
    private TermContainer termContainer;
    private Term rootTerm;
    private List<Term> level1terms = new ArrayList<Term>();
    private HashSet<Subset> availableSubsets = new HashSet();
    private HashMap<String, String> alternativeId2primaryId;
    private Subset relevantSubset;
    private Term relevantSubontology;

    @Deprecated
    public Ontology(TermContainer newTermContainer) {
        Ontology.init(this, newTermContainer);
    }

    private Ontology() {
    }

    public Ontology getInducedGraph(Collection<TermID> termIDs) {
        Ontology subgraph = new Ontology();
        HashSet<Term> allTerms = new HashSet<Term>();
        for (TermID tid : termIDs) {
            for (TermID tid2 : this.getTermsOfInducedGraph(null, tid)) {
                allTerms.add(this.getTerm(tid2));
            }
        }
        subgraph.availableSubsets = this.availableSubsets;
        subgraph.graph = this.graph.subGraph((Set<Term>)allTerms);
        subgraph.termContainer = this.termContainer;
        subgraph.availableSubsets = this.availableSubsets;
        subgraph.assignLevel1TermsAndFixRoot();
        return subgraph;
    }

    public ArrayList<Term> getLeafTerms() {
        ArrayList<Term> leafTerms = new ArrayList<Term>();
        for (Term t : this.graph.getVertices()) {
            if (this.graph.getOutDegree(t) != 0) continue;
            leafTerms.add(t);
        }
        return leafTerms;
    }

    public Collection<TermID> getLeafTermIDs() {
        ArrayList<TermID> leafTerms = new ArrayList<TermID>();
        for (Term t : this.graph.getVertices()) {
            if (this.graph.getOutDegree(t) != 0) continue;
            leafTerms.add(t.getID());
        }
        return leafTerms;
    }

    public ArrayList<Term> getTermsInTopologicalOrder() {
        return this.graph.topologicalOrder();
    }

    public SlimDirectedGraphView<Term> getSlimGraphView() {
        return SlimDirectedGraphView.create(this.graph);
    }

    public SlimDirectedGraphView<TermID> getTermIDSlimGraphView() {
        return SlimDirectedGraphView.create(this.graph, new SlimDirectedGraphView.Map<Term, TermID>(){

            @Override
            public TermID map(Term key) {
                return key.getID();
            }
        });
    }

    private void assignLevel1TermsAndFixRoot() {
        this.level1terms = new ArrayList<Term>();
        for (Term term : this.graph) {
            if (this.graph.getInDegree(term) != 0 || term.isObsolete()) continue;
            this.level1terms.add(term);
        }
        if (this.level1terms.size() > 1) {
            StringBuilder level1StringBuilder = new StringBuilder();
            level1StringBuilder.append("\"");
            level1StringBuilder.append(this.level1terms.get(0).getName());
            level1StringBuilder.append("\"");
            for (int i = 1; i < this.level1terms.size(); ++i) {
                level1StringBuilder.append(" ,\"");
                level1StringBuilder.append(this.level1terms.get(i).getName());
                level1StringBuilder.append("\"");
            }
            String rootName = "root";
            if (this.level1terms.size() == 3) {
                boolean isGO = false;
                for (Term t : this.level1terms) {
                    if (level1TermNames.contains(t.getName().toString().toLowerCase())) {
                        isGO = true;
                        continue;
                    }
                    isGO = false;
                    break;
                }
                if (isGO) {
                    rootName = "Gene Ontology";
                }
            }
            this.rootTerm = new Term(this.level1terms.get(0).getID().getPrefix().toString() + ":0000000", rootName, new ParentTermID[0]);
            logger.log(Level.INFO, "Ontology contains multiple level-one terms: " + level1StringBuilder.toString() + ". Adding artificial root term \"" + this.rootTerm.getID().toString() + "\".");
            this.rootTerm.setSubsets(new ArrayList<Subset>(this.availableSubsets));
            this.graph.addVertex(this.rootTerm);
            for (Term lvl1 : this.level1terms) {
                this.graph.addEdge(new OntologyEdge(this.rootTerm, lvl1, TermRelation.UNKOWN));
            }
        } else if (this.level1terms.size() == 1) {
            this.rootTerm = this.level1terms.get(0);
            logger.log(Level.INFO, "Ontology contains a single level-one term (" + this.rootTerm.toString() + "");
        }
    }

    public boolean isRootTerm(TermID id) {
        return id.equals(this.rootTerm.getID());
    }

    public boolean isArtificialRootTerm(TermID id) {
        return this.isRootTerm(id) && this.getLevel1Terms().contains(id);
    }

    public Term getRootTerm() {
        return this.rootTerm;
    }

    public Collection<Subset> getAvailableSubsets() {
        return this.availableSubsets;
    }

    private Term getTermOrRoot(String termID) {
        Term term = termID.equals(this.rootTerm.getIDAsString()) ? this.rootTerm : this.termContainer.get(termID);
        return term;
    }

    public Set<String> getTermChildrenAsStrings(String termID) {
        Term term = this.getTermOrRoot(termID);
        HashSet<String> terms = new HashSet<String>();
        Iterator<Edge<Term>> edgeIter = this.graph.getOutEdges(term);
        while (edgeIter.hasNext()) {
            terms.add(edgeIter.next().getDest().getIDAsString());
        }
        return terms;
    }

    public Set<String> getTermParentsAsStrings(String termID) {
        Term term = this.getTermOrRoot(termID);
        HashSet<String> terms = new HashSet<String>();
        Iterator<Edge<Term>> edgeIter = this.graph.getInEdges(term);
        while (edgeIter.hasNext()) {
            terms.add(edgeIter.next().getSource().getIDAsString());
        }
        return terms;
    }

    public Set<TermID> getTermChildren(TermID termID) {
        Term goTerm = this.rootTerm.getID().id == termID.id ? this.rootTerm : this.termContainer.get(termID);
        HashSet<TermID> terms = new HashSet<TermID>();
        Iterator<Edge<Term>> edgeIter = this.graph.getOutEdges(goTerm);
        while (edgeIter.hasNext()) {
            terms.add(edgeIter.next().getDest().getID());
        }
        return terms;
    }

    public Set<Term> getTermChildren(Term term) {
        Term goTerm = this.rootTerm.getID().id == term.getID().id ? this.rootTerm : this.termContainer.get(term.getID());
        HashSet<Term> terms = new HashSet<Term>();
        Iterator<Edge<Term>> edgeIter = this.graph.getOutEdges(goTerm);
        while (edgeIter.hasNext()) {
            terms.add(edgeIter.next().getDest());
        }
        return terms;
    }

    public Set<TermID> getTermParents(TermID goTermID) {
        HashSet<TermID> terms = new HashSet<TermID>();
        if (this.rootTerm.getID().id == goTermID.id) {
            return terms;
        }
        Term goTerm = goTermID.equals(this.rootTerm.getIDAsString()) ? this.rootTerm : this.termContainer.get(goTermID);
        Iterator<Edge<Term>> edgeIter = this.graph.getInEdges(goTerm);
        while (edgeIter.hasNext()) {
            terms.add(edgeIter.next().getSource().getID());
        }
        return terms;
    }

    public Set<Term> getTermParents(Term term) {
        HashSet<Term> terms = new HashSet<Term>();
        if (this.rootTerm.getID().id == term.getID().id) {
            return terms;
        }
        Term goTerm = term.getID().equals(this.rootTerm.getIDAsString()) ? this.rootTerm : this.termContainer.get(term.getID());
        Iterator<Edge<Term>> edgeIter = this.graph.getInEdges(goTerm);
        while (edgeIter.hasNext()) {
            terms.add(edgeIter.next().getSource());
        }
        return terms;
    }

    public Set<ParentTermID> getTermParentsWithRelation(TermID goTermID) {
        HashSet<ParentTermID> terms = new HashSet<ParentTermID>();
        if (this.rootTerm.getID().id == goTermID.id) {
            return terms;
        }
        Term goTerm = goTermID.equals(this.rootTerm.getIDAsString()) ? this.rootTerm : this.termContainer.get(goTermID);
        Iterator<Edge<Term>> edgeIter = this.graph.getInEdges(goTerm);
        while (edgeIter.hasNext()) {
            OntologyEdge t = (OntologyEdge)edgeIter.next();
            terms.add(new ParentTermID(((Term)t.getSource()).getID(), t.getRelation()));
        }
        return terms;
    }

    public TermRelation getDirectRelation(TermID parent, TermID term) {
        Set<ParentTermID> parents = this.getTermParentsWithRelation(term);
        for (ParentTermID p : parents) {
            if (!p.termid.equals(parent)) continue;
            return p.relation;
        }
        return null;
    }

    public Set<TermID> getTermsSiblings(TermID tid) {
        Set<TermID> parentTerms = this.getTermParents(tid);
        HashSet<TermID> siblings = new HashSet<TermID>();
        for (TermID p : parentTerms) {
            siblings.addAll(this.getTermChildren(p));
        }
        siblings.remove(tid);
        return siblings;
    }

    public boolean existsPath(TermID sourceID, TermID destID) {
        if (this.isRootTerm(destID)) {
            return this.isRootTerm(sourceID);
        }
        final boolean[] pathExists = new boolean[1];
        final Term source = this.termContainer.get(sourceID);
        Term dest = this.termContainer.get(destID);
        this.graph.bfs(dest, true, new AbstractGraph.IVisitor<Term>(){

            @Override
            public boolean visited(Term vertex) {
                if (!vertex.equals(source)) {
                    return true;
                }
                pathExists[0] = true;
                return false;
            }
        });
        return pathExists[0];
    }

    public void walkToSource(TermID goTermID, IVisitingGOVertex vistingVertex) {
        ArrayList<TermID> set = new ArrayList<TermID>(1);
        set.add(goTermID);
        this.walkToSource(set, vistingVertex);
    }

    private ArrayList<Term> termIDsToTerms(Collection<TermID> termIDSet) {
        ArrayList<Term> termList = new ArrayList<Term>(termIDSet.size());
        for (TermID id : termIDSet) {
            Term t = this.isRootTerm(id) ? this.rootTerm : this.termContainer.get(id);
            if (t == null) {
                throw new IllegalArgumentException("\"" + id + "\" could not be mapped to a known term!");
            }
            termList.add(t);
        }
        return termList;
    }

    public void walkToSource(Collection<TermID> termIDSet, IVisitingGOVertex vistingVertex) {
        this.graph.bfs(this.termIDsToTerms(termIDSet), true, (AbstractGraph.IVisitor<Term>)vistingVertex);
    }

    public void walkToSource(Collection<TermID> termIDSet, IVisitingGOVertex vistingVertex, final Set<TermRelation> relationsToFollow) {
        this.graph.bfs(this.termIDsToTerms(termIDSet), new AbstractGraph.INeighbourGrabber<Term>(){

            @Override
            public Iterator<Term> grabNeighbours(Term t) {
                Iterator<Edge<Term>> inIter = Ontology.this.graph.getInEdges(t);
                ArrayList termsToConsider = new ArrayList();
                while (inIter.hasNext()) {
                    OntologyEdge edge = (OntologyEdge)inIter.next();
                    if (!relationsToFollow.contains((Object)edge.getRelation())) continue;
                    termsToConsider.add(edge.getSource());
                }
                return termsToConsider.iterator();
            }
        }, (AbstractGraph.IVisitor<Term>)vistingVertex);
    }

    public void walkToSinks(TermID goTermID, IVisitingGOVertex vistingVertex) {
        ArrayList<TermID> set = new ArrayList<TermID>(1);
        set.add(goTermID);
        this.walkToSinks(set, vistingVertex);
    }

    public void walkToSinks(Collection<TermID> goTermIDSet, IVisitingGOVertex vistingVertex) {
        this.graph.bfs(this.termIDsToTerms(goTermIDSet), false, (AbstractGraph.IVisitor<Term>)vistingVertex);
    }

    @Deprecated
    public TermMap getTermContainer() {
        return this.termContainer;
    }

    public TermMap getTermMap() {
        return this.termContainer;
    }

    public Term getTerm(String termId) {
        Term go = this.termContainer.get(termId);
        if (go == null) {
            try {
                TermID id = new TermID(termId);
                if (id.id == this.rootTerm.getID().id) {
                    return this.rootTerm;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (!this.graph.containsVertex(go)) {
            return null;
        }
        return go;
    }

    public Term getTermIncludingAlternatives(String termId) {
        Term term = this.getTerm(termId);
        if (term != null) {
            return term;
        }
        if (this.alternativeId2primaryId == null) {
            this.setUpMappingAlternativeId2PrimaryId();
        }
        if (this.alternativeId2primaryId.containsKey(termId)) {
            String primaryId = this.alternativeId2primaryId.get(termId);
            term = this.termContainer.get(primaryId);
        }
        if (term == null) {
            try {
                TermID id = new TermID(termId);
                if (id.id == this.rootTerm.getID().id) {
                    return this.rootTerm;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return term;
    }

    private void setUpMappingAlternativeId2PrimaryId() {
        this.alternativeId2primaryId = new HashMap();
        for (Term t : this.termContainer) {
            String primaryId = t.getIDAsString();
            for (TermID alternativeTermId : t.getAlternatives()) {
                this.alternativeId2primaryId.put(alternativeTermId.toString(), primaryId);
            }
        }
    }

    public Term getTerm(TermID id) {
        Term go = this.termContainer.get(id);
        if (go == null && id.id == this.rootTerm.getID().id) {
            return this.rootTerm;
        }
        return go;
    }

    public boolean termExists(TermID term) {
        return this.graph.getOutDegree(this.getTerm(term)) != -1;
    }

    public Set<Term> getSetOfTermsFromSetOfTermIds(Set<TermID> termIDs) {
        return this.termSet(termIDs);
    }

    public Set<Term> termSet(Iterable<TermID> termIDs) {
        HashSet<Term> termSet = new HashSet<Term>();
        for (TermID tid : termIDs) {
            termSet.add(this.getTerm(tid));
        }
        return termSet;
    }

    private static <A extends Collection<TermID>> A termIDs(A termIDs, Iterable<Term> terms) {
        for (Term t : terms) {
            termIDs.add((TermID)t.getID());
        }
        return termIDs;
    }

    public static List<TermID> termIDList(Iterable<Term> terms) {
        return Ontology.termIDs(new ArrayList(), terms);
    }

    public static List<TermID> termIDList(Collection<Term> terms) {
        return Ontology.termIDs(new ArrayList(terms.size()), terms);
    }

    public static Set<TermID> termIDSet(Iterable<Term> terms) {
        return Ontology.termIDs(new HashSet(), terms);
    }

    public Set<TermID> getTermsOfInducedGraph(final TermID rootTermID, TermID termID) {
        HashSet<TermID> nodeSet = new HashSet<TermID>();
        class Visitor
        implements IVisitingGOVertex {
            public Ontology graph;
            public HashSet<TermID> nodeSet;

            Visitor() {
            }

            @Override
            public boolean visited(Term term) {
                if (rootTermID != null && !this.graph.isRootTerm(rootTermID)) {
                    if (term.getID().equals(rootTermID) || this.graph.existsPath(rootTermID, term.getID())) {
                        this.nodeSet.add(term.getID());
                    }
                } else {
                    this.nodeSet.add(term.getID());
                }
                return true;
            }
        }
        Visitor visitor = new Visitor();
        visitor.nodeSet = nodeSet;
        visitor.graph = this;
        this.walkToSource(termID, (IVisitingGOVertex)visitor);
        return nodeSet;
    }

    public Collection<Term> getLevel1Terms() {
        return this.level1terms;
    }

    public Collection<TermID> getSharedParents(TermID t1, TermID t2) {
        final Set<TermID> p1 = this.getTermsOfInducedGraph(null, t1);
        final ArrayList<TermID> sharedParents = new ArrayList<TermID>();
        this.walkToSource(t2, new IVisitingGOVertex(){

            @Override
            public boolean visited(Term t2) {
                if (p1.contains(t2.getID())) {
                    sharedParents.add(t2.getID());
                }
                return true;
            }
        });
        return sharedParents;
    }

    public GOLevels getGOLevels(final Set<TermID> termids) {
        Term transRoot;
        DirectedGraph<Term> transGraph;
        if (this.getRelevantSubontology() != null && !this.isRootTerm(this.getRelevantSubontology()) || this.getRelevantSubset() != null) {
            Ontology ontologyTransGraph = this.getOntlogyOfRelevantTerms();
            transGraph = ontologyTransGraph.graph;
            transRoot = ontologyTransGraph.getRootTerm();
        } else {
            transGraph = this.graph;
            transRoot = this.rootTerm;
        }
        final GOLevels levels = new GOLevels();
        transGraph.singleSourceLongestPath(transRoot, new DirectedGraph.IDistanceVisitor<Term>(){

            @Override
            public boolean visit(Term vertex, List<Term> path, int distance) {
                if (termids.contains(vertex.getID())) {
                    levels.putLevel(vertex.getID(), distance);
                }
                return true;
            }
        });
        return levels;
    }

    public int getNumberOfTerms() {
        return this.graph.getNumberOfVertices();
    }

    public int maximumTermID() {
        int id = 0;
        for (Term t : this.termContainer) {
            if (t.getID().id <= id) continue;
            id = t.getID().id;
        }
        return id;
    }

    @Override
    public Iterator<Term> iterator() {
        return this.graph.getVertexIterator();
    }

    public void setRelevantSubset(String subsetName) {
        for (Subset s : this.availableSubsets) {
            if (!s.getName().equals(subsetName)) continue;
            this.relevantSubset = s;
            return;
        }
        this.relevantSubset = null;
        throw new IllegalArgumentException("Subset \"" + subsetName + "\" couldn't be found!");
    }

    public Subset getRelevantSubset() {
        return this.relevantSubset;
    }

    public void setRelevantSubontology(String subontologyName) {
        for (Term t : this.termContainer) {
            if (!t.getName().equals(subontologyName)) continue;
            this.relevantSubontology = t;
            return;
        }
        throw new IllegalArgumentException("Subontology \"" + subontologyName + "\" couldn't be found!");
    }

    public TermID getRelevantSubontology() {
        if (this.relevantSubontology != null) {
            return this.relevantSubontology.getID();
        }
        return this.rootTerm.getID();
    }

    public boolean isRelevantTerm(Term term) {
        if (this.relevantSubset != null) {
            boolean found = false;
            for (Subset s : term.getSubsets()) {
                if (!s.equals(this.relevantSubset)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        return this.relevantSubontology == null || term.getID().id == this.relevantSubontology.getID().id || this.existsPath(this.relevantSubontology.getID(), term.getID());
    }

    public boolean isRelevantTermID(TermID termId) {
        Term t = this.isRootTerm(termId) ? this.rootTerm : this.termContainer.get(termId);
        return this.isRelevantTerm(t);
    }

    public TermID findARedundantISARelation(Term t) {
        Set<TermID> parents = this.getTermParents(t.getID());
        Set<TermID> allInducedTerms = this.getTermsOfInducedGraph(null, t.getID());
        for (TermID p : parents) {
            HashSet<TermID> thisInduced = new HashSet<TermID>();
            for (TermID p2 : parents) {
                if (p.equals(p2)) continue;
                thisInduced.addAll(this.getTermsOfInducedGraph(null, p2));
            }
            if (thisInduced.size() != allInducedTerms.size() - 1) continue;
            return p;
        }
        return null;
    }

    public void findRedundantISARelations() {
        for (Term t : this) {
            TermID redundant = this.findARedundantISARelation(t);
            if (redundant == null) continue;
            logger.log(Level.INFO, "{} ({}) -> {} ({})", new Object[]{t.getName(), t.getIDAsString(), this.getTerm(redundant).getName(), redundant.toString()});
        }
    }

    public Ontology getOntlogyOfRelevantTerms() {
        HashSet<Term> terms = new HashSet<Term>();
        for (Term t : this) {
            if (!this.isRelevantTerm(t)) continue;
            terms.add(t);
        }
        DirectedGraph<Term> trans = this.graph.pathMaintainingSubGraph(terms);
        Ontology g = new Ontology();
        g.graph = trans;
        g.termContainer = this.termContainer;
        g.assignLevel1TermsAndFixRoot();
        return g;
    }

    public DirectedGraph<Term> getGraph() {
        return this.graph;
    }

    public void mergeTerms(Term t1, Iterable<Term> eqTerms) {
        HashSet<TermID> t1ExistingAlternatives = new HashSet<TermID>(Arrays.asList(t1.getAlternatives()));
        for (Term t : eqTerms) {
            TermID tId = t.getID();
            if (t1ExistingAlternatives.contains(tId)) continue;
            t1.addAlternativeId(tId);
        }
        this.graph.mergeVertices(t1, eqTerms);
    }

    private static void init(Ontology o, TermContainer tc) {
        o.termContainer = tc;
        o.graph = new DirectedGraph();
        for (Term term : tc) {
            o.graph.addVertex(term);
        }
        int skippedEdges = 0;
        for (Term term : tc) {
            if (term.getSubsets() != null) {
                for (Serializable serializable : term.getSubsets()) {
                    o.availableSubsets.add((Subset)serializable);
                }
            }
            for (Serializable serializable : term.getParents()) {
                if (term.getID().equals(((ParentTermID)serializable).termid)) {
                    logger.log(Level.INFO, "Detected self-loop in the definition of the ontology (term " + term.getIDAsString() + "). This link has been ignored.");
                    continue;
                }
                if (tc.get(((ParentTermID)serializable).termid) == null) {
                    logger.log(Level.INFO, "Could not add a link from term " + term.toString() + " to " + ((ParentTermID)serializable).termid.toString() + " as the latter's definition is missing.");
                    ++skippedEdges;
                    continue;
                }
                o.graph.addEdge(new OntologyEdge(tc.get(((ParentTermID)serializable).termid), term, ((ParentTermID)serializable).relation));
            }
        }
        if (skippedEdges > 0) {
            logger.log(Level.INFO, "A total of " + skippedEdges + " edges were skipped.");
        }
        o.assignLevel1TermsAndFixRoot();
    }

    public static Ontology create(TermContainer tc) {
        Ontology o = new Ontology();
        Ontology.init(o, tc);
        return o;
    }

    public static class GOLevels {
        private HashMap<Integer, HashSet<TermID>> level2terms = new HashMap();
        private HashMap<TermID, Integer> terms2level = new HashMap();
        private int maxLevel = -1;

        public void putLevel(TermID tid, int distance) {
            HashSet<TermID> levelTerms = this.level2terms.get(distance);
            if (levelTerms == null) {
                levelTerms = new HashSet();
                this.level2terms.put(distance, levelTerms);
            }
            levelTerms.add(tid);
            this.terms2level.put(tid, distance);
            if (distance > this.maxLevel) {
                this.maxLevel = distance;
            }
        }

        public int getTermLevel(TermID tid) {
            Integer level = this.terms2level.get(tid);
            if (level == null) {
                return -1;
            }
            return level;
        }

        public Set<TermID> getLevelTermSet(int level) {
            return this.level2terms.get(level);
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }
    }

    public static interface IVisitingGOVertex
    extends AbstractGraph.IVisitor<Term> {
    }
}

