/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.ontology;

import java.io.Serializable;
import java.util.HashMap;
import ontologizer.types.ByteString;

public class Namespace
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static HashMap<Namespace, NamespaceEnum> namespaceMap = new HashMap();
    public static Namespace UNKOWN_NAMESPACE;
    private ByteString name;

    public static NamespaceEnum getNamespaceEnum(Namespace namespace) {
        NamespaceEnum e = namespaceMap.get(namespace);
        if (e == null) {
            return NamespaceEnum.UNSPECIFIED;
        }
        return e;
    }

    public Namespace(String newName) {
        this.name = new ByteString(newName);
    }

    public Namespace(ByteString newName) {
        this.name = newName;
    }

    public ByteString getName() {
        return this.name;
    }

    public String getAbbreviatedName() {
        return Character.toUpperCase(this.name.toString().charAt(0)) + "";
    }

    public boolean equals(Object obj) {
        return this.name.equals(((Namespace)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static {
        namespaceMap.put(new Namespace(new ByteString("biological_process")), NamespaceEnum.BIOLOGICAL_PROCESS);
        namespaceMap.put(new Namespace(new ByteString("molecular_function")), NamespaceEnum.MOLECULAR_FUNCTION);
        namespaceMap.put(new Namespace(new ByteString("cellular_component")), NamespaceEnum.CELLULAR_COMPONENT);
        UNKOWN_NAMESPACE = new Namespace(new ByteString("unknown"));
    }

    public static enum NamespaceEnum {
        BIOLOGICAL_PROCESS,
        MOLECULAR_FUNCTION,
        CELLULAR_COMPONENT,
        UNSPECIFIED;

    }
}

