/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.enumeration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ontologizer.association.Association;
import ontologizer.association.Gene2Associations;
import ontologizer.ontology.Ontology;
import ontologizer.ontology.Term;
import ontologizer.ontology.TermID;
import ontologizer.types.ByteString;

public class TermEnumerator
implements Iterable<TermID> {
    private Ontology graph;
    private HashMap<TermID, TermAnnotatedGenes> map;

    public TermEnumerator(Ontology graph) {
        this.graph = graph;
        this.map = new HashMap();
    }

    public void push(Gene2Associations geneAssociations) {
        this.push(geneAssociations, null);
    }

    public void push(Gene2Associations geneAssociations, Set<ByteString> evidences) {
        ByteString geneName = geneAssociations.name();
        HashSet<TermID> termIDSet = new HashSet<TermID>();
        for (Association association : geneAssociations) {
            TermID termID = association.getTermID();
            if (!this.graph.isRelevantTermID(termID) || evidences != null && !evidences.contains(association.getEvidence())) continue;
            TermAnnotatedGenes termGenes = this.map.get(termID);
            if (termGenes == null) {
                termGenes = new TermAnnotatedGenes();
                this.map.put(termID, termGenes);
            }
            termGenes.directAnnotated.add(geneName);
            termIDSet.add(association.getTermID());
        }
        class VisitingGOVertex
        implements Ontology.IVisitingGOVertex {
            private ByteString geneName;

            public VisitingGOVertex(ByteString geneName) {
                this.geneName = geneName;
            }

            @Override
            public boolean visited(Term term) {
                if (TermEnumerator.this.graph.isRelevantTermID(term.getID())) {
                    TermAnnotatedGenes termGenes = (TermAnnotatedGenes)TermEnumerator.this.map.get(term.getID());
                    if (termGenes == null) {
                        termGenes = new TermAnnotatedGenes();
                        TermEnumerator.this.map.put(term.getID(), termGenes);
                    }
                    termGenes.totalAnnotated.add(this.geneName);
                }
                return true;
            }
        }
        VisitingGOVertex vistingGOVertex = new VisitingGOVertex(geneName);
        this.graph.walkToSource(termIDSet, (Ontology.IVisitingGOVertex)vistingGOVertex);
    }

    public TermAnnotatedGenes getAnnotatedGenes(TermID goTermID) {
        if (this.map.containsKey(goTermID)) {
            return this.map.get(goTermID);
        }
        return new TermAnnotatedGenes();
    }

    public GOTermOftenAnnotatedCount[] getTermsOftenAnnotatedWithAndNotOnPath(TermID goTermID) {
        ArrayList<GOTermOftenAnnotatedCount> list = new ArrayList<GOTermOftenAnnotatedCount>();
        TermAnnotatedGenes goTermIDAnnotated = this.map.get(goTermID);
        if (goTermIDAnnotated == null) {
            return null;
        }
        for (TermID curTerm : this.map.keySet()) {
            if (this.graph.isRootTerm(curTerm) || curTerm.equals(goTermID) || this.graph.existsPath(curTerm, goTermID) || this.graph.existsPath(goTermID, curTerm)) continue;
            int count = 0;
            TermAnnotatedGenes curTermAnnotated = this.map.get(curTerm);
            for (ByteString gene : curTermAnnotated.totalAnnotated) {
                if (!goTermIDAnnotated.totalAnnotated.contains(gene)) continue;
                ++count;
            }
            if (count == 0) continue;
            GOTermOftenAnnotatedCount tc = new GOTermOftenAnnotatedCount();
            tc.term = curTerm;
            tc.counts = count;
            list.add(tc);
        }
        Object[] termArray = new GOTermOftenAnnotatedCount[list.size()];
        list.toArray(termArray);
        Arrays.sort(termArray);
        return termArray;
    }

    @Override
    public Iterator<TermID> iterator() {
        return this.map.keySet().iterator();
    }

    public int getTotalNumberOfAnnotatedTerms() {
        return this.map.size();
    }

    public Set<TermID> getAllAnnotatedTermsAsSet() {
        LinkedHashSet<TermID> at = new LinkedHashSet<TermID>();
        for (TermID t : this) {
            at.add(t);
        }
        return at;
    }

    public List<TermID> getAllAnnotatedTermsAsList() {
        ArrayList<TermID> at = new ArrayList<TermID>();
        for (TermID t : this) {
            at.add(t);
        }
        return at;
    }

    public Set<ByteString> getGenes() {
        return new LinkedHashSet<ByteString>(this.getGenesAsList());
    }

    public List<ByteString> getGenesAsList() {
        return this.getAnnotatedGenes((TermID)this.graph.getRootTerm().getID()).totalAnnotated;
    }

    public void removeTerms(IRemover remove) {
        ArrayList<TermID> toBeRemoved = new ArrayList<TermID>();
        for (Map.Entry<TermID, TermAnnotatedGenes> entry : this.map.entrySet()) {
            if (!remove.remove(entry.getKey(), entry.getValue())) continue;
            toBeRemoved.add(entry.getKey());
        }
        for (TermID tid : toBeRemoved) {
            this.map.remove(tid);
        }
    }

    public static interface IRemover {
        public boolean remove(TermID var1, TermAnnotatedGenes var2);
    }

    public class GOTermOftenAnnotatedCount
    implements Comparable<GOTermOftenAnnotatedCount> {
        public TermID term;
        public int counts;

        @Override
        public int compareTo(GOTermOftenAnnotatedCount o) {
            return o.counts - this.counts;
        }
    }

    public static class TermAnnotatedGenes {
        public List<ByteString> directAnnotated = new ArrayList<ByteString>();
        public List<ByteString> totalAnnotated = new ArrayList<ByteString>();

        public int directAnnotatedCount() {
            return this.directAnnotated.size();
        }

        public int totalAnnotatedCount() {
            return this.totalAnnotated.size();
        }
    }
}

