/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.enumeration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import ontologizer.enumeration.TermEnumerator;
import ontologizer.ontology.TermID;
import ontologizer.types.ByteString;

public class ItemEnumerator
implements Iterable<ByteString> {
    private HashMap<ByteString, ArrayList<TermID>> items2Terms;
    private HashMap<ByteString, ArrayList<TermID>> items2DirectTerms;

    private ItemEnumerator() {
    }

    public ArrayList<TermID> getTermsAnnotatedToTheItem(ByteString item) {
        return this.items2Terms.get(item);
    }

    public ArrayList<TermID> getTermsDirectlyAnnotatedToTheItem(ByteString item) {
        return this.items2DirectTerms.get(item);
    }

    public ArrayList<TermID> getAllTermIDs() {
        LinkedHashSet<TermID> allTermIDs = new LinkedHashSet<TermID>();
        for (ArrayList<TermID> tids : this.items2Terms.values()) {
            allTermIDs.addAll(tids);
        }
        return new ArrayList<TermID>(allTermIDs);
    }

    public static ItemEnumerator createFromTermEnumerator(TermEnumerator termEnumerator) {
        HashMap<ByteString, ArrayList<TermID>> items2Terms = new HashMap<ByteString, ArrayList<TermID>>();
        HashMap<ByteString, ArrayList<TermID>> items2DirectTerms = new HashMap<ByteString, ArrayList<TermID>>();
        for (TermID tid : termEnumerator) {
            ArrayList<TermID> al;
            TermEnumerator.TermAnnotatedGenes genes = termEnumerator.getAnnotatedGenes(tid);
            for (ByteString g : genes.totalAnnotated) {
                al = (ArrayList<TermID>)items2Terms.get(g);
                if (al == null) {
                    al = new ArrayList<TermID>();
                    items2Terms.put(g, al);
                }
                al.add(tid);
            }
            for (ByteString g : genes.directAnnotated) {
                al = (ArrayList<TermID>)items2DirectTerms.get(g);
                if (al == null) {
                    al = new ArrayList<TermID>();
                    items2DirectTerms.put(g, al);
                }
                al.add(tid);
            }
        }
        ItemEnumerator itemEnum = new ItemEnumerator();
        itemEnum.items2Terms = items2Terms;
        itemEnum.items2DirectTerms = items2DirectTerms;
        return itemEnum;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ByteString gene : this.items2Terms.keySet()) {
            builder.append(gene);
            builder.append(": ");
            for (TermID tid : this.items2Terms.get(gene)) {
                builder.append(tid.toString());
                builder.append(",");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    public Iterator<ByteString> iterator() {
        return this.items2Terms.keySet().iterator();
    }
}

