/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.association;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import ontologizer.association.Association;
import ontologizer.ontology.TermID;
import ontologizer.types.ByteString;

public class Gene2Associations
implements Iterable<Association>,
Serializable {
    private static final long serialVersionUID = 1L;
    private ByteString gene;
    private ArrayList<Association> associations = new ArrayList();

    public Gene2Associations(ByteString name) {
        this.gene = name;
    }

    public void add(Association a) {
        if (this.gene.equals(a.getObjectSymbol())) {
            if (this.containsID(a.getTermID())) {
                return;
            }
            this.associations.add(a);
        }
    }

    public ByteString name() {
        return this.gene;
    }

    public ArrayList<TermID> getAssociations() {
        ArrayList<TermID> a = new ArrayList<TermID>();
        for (Association assoc : this.associations) {
            a.add(assoc.getTermID());
        }
        return a;
    }

    @Override
    public Iterator<Association> iterator() {
        return this.associations.iterator();
    }

    public boolean containsID(TermID tid) {
        for (Association assoc : this.associations) {
            if (!assoc.getTermID().equals(tid)) continue;
            return true;
        }
        return false;
    }
}

