/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.association;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ontologizer.association.AnnotationContext;
import ontologizer.association.Association;
import ontologizer.association.Gene2Associations;
import ontologizer.types.ByteString;

public class AssociationContainer
implements Iterable<Gene2Associations>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Gene2Associations[] associations;
    private AnnotationContext annotationMapping;

    public AssociationContainer(List<Association> assocs, AnnotationContext annotationMapping) {
        this.annotationMapping = annotationMapping;
        this.associations = new Gene2Associations[annotationMapping.getSymbols().length];
        for (Association a : assocs) {
            this.addAssociation(a);
        }
    }

    private void addAssociation(Association a) {
        ByteString symbol = a.getObjectSymbol();
        int index = this.annotationMapping.mapSymbol(a.getObjectSymbol());
        if (index == Integer.MAX_VALUE) {
            return;
        }
        Gene2Associations g2a = this.associations[index];
        if (g2a == null) {
            this.associations[index] = g2a = new Gene2Associations(symbol);
        }
        g2a.add(a);
    }

    public Gene2Associations get(ByteString geneName) {
        int index = this.annotationMapping.mapSymbol(geneName);
        if (index == Integer.MAX_VALUE && (index = this.annotationMapping.mapObjectID(geneName)) == Integer.MAX_VALUE) {
            index = this.annotationMapping.mapSynonym(geneName);
        }
        if (index == Integer.MAX_VALUE) {
            return null;
        }
        return this.associations[index];
    }

    public boolean isObjectSymbol(ByteString name) {
        return this.annotationMapping.mapSymbol(name) != Integer.MAX_VALUE;
    }

    public boolean isObjectID(ByteString name) {
        return this.annotationMapping.mapObjectID(name) != Integer.MAX_VALUE;
    }

    public boolean isSynonym(ByteString name) {
        return this.annotationMapping.mapSynonym(name) != Integer.MAX_VALUE;
    }

    public Set<ByteString> getAllAnnotatedGenes() {
        HashSet<ByteString> symbols = new HashSet<ByteString>();
        for (ByteString bs : this.annotationMapping.getSymbols()) {
            symbols.add(bs);
        }
        return symbols;
    }

    public boolean containsGene(ByteString g1) {
        return this.get(g1) != null;
    }

    @Override
    public Iterator<Gene2Associations> iterator() {
        return new Iterator<Gene2Associations>(){
            int current;

            @Override
            public boolean hasNext() {
                return this.current != AssociationContainer.this.associations.length;
            }

            @Override
            public Gene2Associations next() {
                Gene2Associations value = AssociationContainer.this.associations[this.current];
                ++this.current;
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Map<String, Integer> getAllEvidenceCodes() {
        HashMap<String, Integer> evidenceCounts = new HashMap<String, Integer>();
        for (Gene2Associations g2a : this.associations) {
            for (Association a : g2a) {
                String ev = a.getEvidence().toString();
                int count = evidenceCounts.containsKey(ev) ? (Integer)evidenceCounts.get(ev) + 1 : 1;
                evidenceCounts.put(ev, count);
            }
        }
        return evidenceCounts;
    }

    public Gene2Associations getItemAssociations(int i) {
        return this.associations[i];
    }

    public AnnotationContext getMapping() {
        return this.annotationMapping;
    }
}

