/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.association;

import java.io.Serializable;
import java.util.regex.Pattern;
import ontologizer.ontology.PrefixPool;
import ontologizer.ontology.TermID;
import ontologizer.types.ByteString;

public class Association
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ByteString DB_Object;
    private ByteString DB_Object_Symbol;
    private ByteString evidence;
    private ByteString aspect;
    private TermID termID;
    private boolean notQualifier;
    private ByteString synonym;
    private static final String DELIM = "\t";
    private static final int FIELDS = 15;
    private static final int DBOBJECTFIELD = 1;
    private static final int DBOBJECTSYMBOLFIELD = 2;
    private static final int QUALIFIERFIELD = 3;
    private static final int GOFIELD = 4;
    private static final int EVIDENCEFIELD = 6;
    private static final int ASPECTFIELD = 8;
    private static final int SYNONYMFIELD = 10;
    private static final int DBOBJECTTYPEFIELD = 11;
    private static final Pattern pattern = Pattern.compile("\t");
    private static final ByteString emptyString = ByteString.EMPTY;
    private static final ByteString notString = ByteString.b("NOT");

    public Association(String line) throws Exception {
        Association.initFromLine(this, line, null);
    }

    public Association(ByteString db_object_symbol, int goIntID) {
        this.DB_Object = this.synonym = ByteString.EMPTY;
        this.DB_Object_Symbol = db_object_symbol;
        this.termID = new TermID(goIntID);
    }

    public Association(ByteString db_object_symbol, TermID termID) {
        this.DB_Object = this.synonym = ByteString.EMPTY;
        this.DB_Object_Symbol = db_object_symbol;
        this.termID = termID;
    }

    public Association(ByteString db_object_symbol, String term) {
        this.DB_Object = this.synonym = ByteString.EMPTY;
        this.DB_Object_Symbol = db_object_symbol;
        this.termID = new TermID(term);
    }

    private Association() {
    }

    public TermID getTermID() {
        return this.termID;
    }

    public ByteString getObjectSymbol() {
        return this.DB_Object_Symbol;
    }

    public ByteString getSynonym() {
        return this.synonym;
    }

    public boolean hasNotQualifier() {
        return this.notQualifier;
    }

    public ByteString getDB_Object() {
        return this.DB_Object;
    }

    public ByteString getAspect() {
        return this.aspect;
    }

    public ByteString getEvidence() {
        return this.evidence;
    }

    public void setTermID(TermID termID) {
        this.termID = termID;
    }

    private static void initFromLine(Association a, String line, PrefixPool prefixPool) {
        String[] qualifiers;
        a.DB_Object_Symbol = a.synonym = emptyString;
        a.DB_Object = a.synonym;
        a.termID = null;
        String[] fields = pattern.split(line, 15);
        a.DB_Object = new ByteString(fields[1].trim());
        a.DB_Object_Symbol = new ByteString(fields[2].trim());
        a.evidence = new ByteString(fields[6].trim());
        a.aspect = new ByteString(fields[8].trim());
        for (String qual : qualifiers = fields[3].trim().split("\\|")) {
            if (!qual.equalsIgnoreCase("not")) continue;
            a.notQualifier = true;
        }
        fields[4] = fields[4].trim();
        a.termID = new TermID(fields[4], prefixPool);
        a.synonym = new ByteString(fields[10].trim());
    }

    public static Association createFromGAFLine(String line, PrefixPool pp) {
        Association a = new Association();
        Association.initFromLine(a, line, pp);
        return a;
    }

    public static Association createFromGAFLine(String line) {
        return Association.createFromGAFLine(line, null);
    }

    public static Association createFromGAFLine(ByteString line, PrefixPool pp) {
        return Association.createFromGAFLine(line.toString(), pp);
    }

    public static Association createFromGAFLine(ByteString line) {
        return Association.createFromGAFLine(line, null);
    }

    public static Association createFromGAFLine(byte[] byteBuf, int offset, int len, PrefixPool prefixPool) {
        Association a = new Association();
        a.DB_Object_Symbol = a.synonym = emptyString;
        a.DB_Object = a.synonym;
        int fieldOffset = offset;
        int fieldNo = 0;
        for (int p = offset; p < offset + len; ++p) {
            if (byteBuf[p] != 9) continue;
            switch (fieldNo) {
                case 1: {
                    a.DB_Object = new ByteString(byteBuf, fieldOffset, p);
                    break;
                }
                case 2: {
                    a.DB_Object_Symbol = new ByteString(byteBuf, fieldOffset, p);
                    break;
                }
                case 6: {
                    a.evidence = new ByteString(byteBuf, fieldOffset, p);
                    break;
                }
                case 8: {
                    a.aspect = new ByteString(byteBuf, fieldOffset, p);
                    break;
                }
                case 3: {
                    a.notQualifier = new ByteString(byteBuf, fieldOffset, p).indexOf(notString) != -1;
                    break;
                }
                case 10: {
                    a.synonym = new ByteString(byteBuf, fieldOffset, p);
                    break;
                }
                case 4: {
                    a.termID = new TermID(new ByteString(byteBuf, fieldOffset, p), prefixPool);
                }
            }
            fieldOffset = p + 1;
            ++fieldNo;
        }
        return a;
    }
}

