/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.association;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ontologizer.types.ByteString;
import sonumina.collections.ObjectIntHashMap;

public class AnnotationContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ByteString[] symbols;
    private ByteString[] objectIds;
    private ObjectIntHashMap<ByteString> objectSymbolMap;
    private ObjectIntHashMap<ByteString> objectIdMap;
    private ObjectIntHashMap<ByteString> synonymMap;

    public AnnotationContext(Collection<ByteString> symbols, List<ByteString> objectIds, ObjectIntHashMap<ByteString> objectSymbolMap, ObjectIntHashMap<ByteString> objectIdMap, ObjectIntHashMap<ByteString> synonymMap) {
        if (symbols.size() != objectIds.size()) {
            throw new IllegalArgumentException("Symbols and object ids size must match");
        }
        this.symbols = new ByteString[symbols.size()];
        symbols.toArray(this.symbols);
        this.objectIds = new ByteString[objectIds.size()];
        objectIds.toArray(this.objectIds);
        this.objectSymbolMap = objectSymbolMap;
        this.objectIdMap = objectIdMap;
        this.synonymMap = synonymMap;
    }

    public AnnotationContext(Collection<ByteString> symbols, HashMap<ByteString, ByteString> synonym2Item, HashMap<ByteString, ByteString> objectId2Item) {
        ByteString symbol;
        int initialSynonymMapSize = 32;
        int initialObjectIdMapSize = 32;
        this.objectSymbolMap = new ObjectIntHashMap();
        HashSet<ByteString> allSymbols = new HashSet<ByteString>(symbols);
        if (synonym2Item != null) {
            for (ByteString otherSymbol : synonym2Item.values()) {
                allSymbols.add(otherSymbol);
            }
            initialSynonymMapSize = synonym2Item.size();
        }
        if (objectId2Item != null) {
            for (ByteString otherSymbol : objectId2Item.values()) {
                allSymbols.add(otherSymbol);
            }
            initialObjectIdMapSize = objectId2Item.size();
        }
        this.symbols = new ByteString[allSymbols.size()];
        this.objectIds = new ByteString[allSymbols.size()];
        this.synonymMap = new ObjectIntHashMap(initialSynonymMapSize);
        this.objectIdMap = new ObjectIntHashMap(initialObjectIdMapSize);
        int i = 0;
        for (ByteString byteString : allSymbols) {
            this.objectSymbolMap.put(byteString, i);
            this.symbols[i] = byteString;
            ++i;
        }
        if (synonym2Item != null) {
            for (Map.Entry entry : synonym2Item.entrySet()) {
                ByteString synonym = (ByteString)entry.getKey();
                symbol = (ByteString)entry.getValue();
                this.synonymMap.put(synonym, this.objectSymbolMap.get(symbol));
            }
        }
        if (objectId2Item != null) {
            for (Map.Entry entry : objectId2Item.entrySet()) {
                ByteString objectId = (ByteString)entry.getKey();
                symbol = (ByteString)entry.getValue();
                this.objectIdMap.put(objectId, this.objectSymbolMap.get(symbol));
            }
        }
    }

    public HashMap<ByteString, ByteString> getSynonym2Symbol() {
        final HashMap<ByteString, ByteString> synonym2symbol = new HashMap<ByteString, ByteString>(this.synonymMap.size());
        this.synonymMap.forEachKeyValue(new ObjectIntHashMap.ObjectIntProcedure<ByteString>(){

            @Override
            public void keyValue(ByteString key, int value) {
                synonym2symbol.put(key, AnnotationContext.this.symbols[value]);
            }
        });
        return synonym2symbol;
    }

    public HashMap<ByteString, ByteString> getDbObjectID2Symbol() {
        final HashMap<ByteString, ByteString> dbObjectID2gene = new HashMap<ByteString, ByteString>(this.synonymMap.size());
        this.objectIdMap.forEachKeyValue(new ObjectIntHashMap.ObjectIntProcedure<ByteString>(){

            @Override
            public void keyValue(ByteString key, int value) {
                dbObjectID2gene.put(key, AnnotationContext.this.symbols[value]);
            }
        });
        return dbObjectID2gene;
    }

    public ByteString[] getSymbols() {
        return this.symbols;
    }

    public int mapSymbol(ByteString name) {
        return this.objectSymbolMap.getIfAbsent(name, Integer.MAX_VALUE);
    }

    public int mapObjectID(ByteString objectid) {
        return this.objectIdMap.getIfAbsent(objectid, Integer.MAX_VALUE);
    }

    public int mapSynonym(ByteString synonym) {
        return this.synonymMap.getIfAbsent(synonym, Integer.MAX_VALUE);
    }

    public int getNumberOfSynonyms() {
        return this.synonymMap.size();
    }
}

