/*
 * Decompiled with CFR 0.152.
 */
package de.onecode.compass.ksp;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSVisitor;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.ksp.OriginatingKSFilesKt;
import de.onecode.compass.api.Destination;
import de.onecode.compass.api.SubGraph;
import de.onecode.compass.ksp.CheckGraphStateKt;
import de.onecode.compass.ksp.GraphState;
import de.onecode.compass.ksp.descriptions.DestinationDescription;
import de.onecode.compass.ksp.descriptions.GraphDescription;
import de.onecode.compass.ksp.discovery.DestinationVisitor;
import de.onecode.compass.ksp.discovery.GraphVisitor;
import de.onecode.compass.ksp.generator.CodeGenerationKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/onecode/compass/ksp/GraphSymbolProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "codeGenerator", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "(Lcom/google/devtools/ksp/processing/CodeGenerator;)V", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "compass-ksp"})
@SourceDebugExtension(value={"SMAP\nGraphSymbolProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphSymbolProcessor.kt\nde/onecode/compass/ksp/GraphSymbolProcessor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,51:1\n1313#2,2:52\n1313#2,2:54\n37#3,2:56\n*S KotlinDebug\n*F\n+ 1 GraphSymbolProcessor.kt\nde/onecode/compass/ksp/GraphSymbolProcessor\n*L\n27#1:52,2\n35#1:54,2\n47#1:56,2\n*E\n"})
public final class GraphSymbolProcessor
implements SymbolProcessor {
    @NotNull
    private final CodeGenerator codeGenerator;

    public GraphSymbolProcessor(@NotNull CodeGenerator codeGenerator) {
        Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
        this.codeGenerator = codeGenerator;
    }

    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        block8: {
            FileSpec fileSpec;
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            String string = Destination.class.getCanonicalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
            Sequence destinationSymbols = Resolver.getSymbolsWithAnnotation$default((Resolver)resolver, (String)string, (boolean)false, (int)2, null);
            if (!destinationSymbols.iterator().hasNext()) {
                return CollectionsKt.emptyList();
            }
            DestinationVisitor destinationVisitor = new DestinationVisitor();
            Sequence $this$forEach$iv = destinationSymbols;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KSAnnotated it = (KSAnnotated)element$iv;
                boolean bl = false;
                it.accept((KSVisitor)destinationVisitor, (Object)Unit.INSTANCE);
            }
            List<DestinationDescription> destinations = destinationVisitor.getDestinations();
            String string2 = SubGraph.class.getCanonicalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalName(...)");
            Sequence subGraphSymbols = Resolver.getSymbolsWithAnnotation$default((Resolver)resolver, (String)string2, (boolean)false, (int)2, null);
            GraphVisitor graphVisitor = new GraphVisitor(destinations);
            Sequence $this$forEach$iv2 = subGraphSymbols;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                KSAnnotated it = (KSAnnotated)element$iv;
                boolean bl = false;
                it.accept((KSVisitor)graphVisitor, (Object)Unit.INSTANCE);
            }
            GraphDescription graph = graphVisitor.getGraph();
            GraphState state = CheckGraphStateKt.checkGraphState(graph);
            FileSpec fileSpec2 = fileSpec = (switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1 -> CodeGenerationKt.generateNavigatorCode(graph);
                case 2 -> CodeGenerationKt.generateAddDestinationCode(graph);
                case 3 -> null;
                default -> throw new NoWhenBranchMatchedException();
            });
            if (fileSpec2 == null) break block8;
            Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)resolver.getAllFiles());
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            KSFile[] kSFileArray = thisCollection$iv.toArray(new KSFile[0]);
            OriginatingKSFilesKt.writeTo((FileSpec)fileSpec2, (CodeGenerator)this.codeGenerator, (Dependencies)new Dependencies(false, Arrays.copyOf(kSFileArray, kSFileArray.length)));
        }
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GraphState.values().length];
            try {
                nArray[GraphState.Standard.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GraphState.NoHome.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GraphState.NoDestinations.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

