/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.smartcardio;

import com.licel.jcardsim.base.CardManager;
import com.licel.jcardsim.io.JavaCardInterface;
import com.licel.jcardsim.smartcardio.JCSCardChannel;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public class JCSCard
extends Card {
    private ATR atr;
    private JavaCardInterface cardInterface;
    private JCSCardChannel basicChannel;

    public JCSCard(JavaCardInterface cardInterface) {
        this.cardInterface = cardInterface;
        this.atr = new ATR(cardInterface.getATR());
        this.basicChannel = new JCSCardChannel(this, 0);
    }

    @Override
    public ATR getATR() {
        return this.atr;
    }

    @Override
    public String getProtocol() {
        return this.cardInterface.getProtocol();
    }

    @Override
    public CardChannel getBasicChannel() {
        return this.basicChannel;
    }

    @Override
    public CardChannel openLogicalChannel() throws CardException {
        return new JCSCardChannel(this, 1);
    }

    @Override
    public void beginExclusive() throws CardException {
    }

    @Override
    public void endExclusive() throws CardException {
    }

    @Override
    public byte[] transmitControlCommand(int i, byte[] bytes) throws CardException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void disconnect(boolean reset) throws CardException {
        if (reset) {
            this.cardInterface.reset();
        }
    }

    ResponseAPDU transmitCommand(CommandAPDU capdu) {
        return new ResponseAPDU(CardManager.dispatchApdu(this.cardInterface, capdu.getBytes()));
    }
}

