/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.smartcardio;

import com.licel.jcardsim.smartcardio.CardSimulator;
import com.licel.jcardsim.utils.AutoResetEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactorySpi;

public final class CardTerminalSimulator {
    private CardTerminalSimulator() {
    }

    public static CardTerminal terminal(CardSimulator cardSimulator, String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (cardSimulator == null) {
            throw new NullPointerException("cardSimulator");
        }
        CardTerminal cardTerminal = CardTerminalSimulator.terminals(name).getTerminal(name);
        cardSimulator.assignToTerminal(cardTerminal);
        return cardTerminal;
    }

    public static CardTerminal terminal(CardSimulator cardSimulator) {
        return CardTerminalSimulator.terminal(cardSimulator, "jCardSim.Terminal");
    }

    public static CardTerminals terminals(String ... names) {
        if (names == null) {
            throw new NullPointerException("names");
        }
        HashSet<String> set = new HashSet<String>(names.length);
        for (String name : names) {
            if (set.contains(name)) {
                throw new IllegalArgumentException("Duplicate name '" + name + "'");
            }
            set.add(name);
        }
        return new CardTerminalsImpl(names);
    }

    static boolean waitForLatch(AutoResetEvent autoResetEvent, long timeoutMilliseconds) throws InterruptedException {
        if (timeoutMilliseconds < 0L) {
            throw new IllegalArgumentException("timeout is negative");
        }
        if (timeoutMilliseconds == 0L) {
            boolean success;
            while (!(success = autoResetEvent.await(1L, TimeUnit.MINUTES))) {
            }
            return true;
        }
        return autoResetEvent.await(timeoutMilliseconds, TimeUnit.MILLISECONDS);
    }

    static final class CardTerminalImpl
    extends CardTerminal {
        private final String name;
        private final Map<CardTerminal, CardTerminals.State> terminalStateMap;
        private final AutoResetEvent terminalsChangeAutoResetEvent;
        private final AutoResetEvent cardPresent = new AutoResetEvent();
        private final AutoResetEvent cardAbsent = new AutoResetEvent();
        private final AtomicReference<CardSimulator> cardSimulatorReference = new AtomicReference();

        CardTerminalImpl(String name, Map<CardTerminal, CardTerminals.State> terminalStateMap, AutoResetEvent terminalsChangeAutoResetEvent) {
            this.name = name;
            this.terminalStateMap = terminalStateMap;
            this.terminalsChangeAutoResetEvent = terminalsChangeAutoResetEvent;
            this.cardAbsent.signal();
            terminalStateMap.put(this, CardTerminals.State.CARD_ABSENT);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Card connect(String protocol) throws CardException {
            CardSimulator cardSimulator = this.cardSimulatorReference.get();
            if (cardSimulator == null) {
                throw new CardNotPresentException("No card inserted. You need to call CardTerminalSimulator#assignToTerminal");
            }
            return cardSimulator.internalConnect(protocol);
        }

        @Override
        public boolean isCardPresent() throws CardException {
            return this.cardSimulatorReference.get() != null;
        }

        @Override
        public boolean waitForCardPresent(long timeoutMilliseconds) throws CardException {
            try {
                return CardTerminalSimulator.waitForLatch(this.cardPresent, timeoutMilliseconds);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        @Override
        public boolean waitForCardAbsent(long timeoutMilliseconds) throws CardException {
            try {
                return CardTerminalSimulator.waitForLatch(this.cardAbsent, timeoutMilliseconds);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void assignSimulator(CardSimulator cardSimulator) {
            Map<CardTerminal, CardTerminals.State> map = this.terminalStateMap;
            synchronized (map) {
                CardSimulator oldCardSimulator = this.cardSimulatorReference.getAndSet(cardSimulator);
                boolean change = false;
                boolean present = false;
                if (oldCardSimulator != null) {
                    oldCardSimulator.internalEject(this);
                    change = true;
                }
                if (cardSimulator != null) {
                    present = true;
                    change = true;
                }
                if (change) {
                    if (present) {
                        this.terminalStateMap.put(this, CardTerminals.State.CARD_INSERTION);
                        this.cardPresent.signal();
                        this.cardAbsent.reset();
                    } else {
                        this.terminalStateMap.put(this, CardTerminals.State.CARD_REMOVAL);
                        this.cardPresent.reset();
                        this.cardAbsent.signal();
                    }
                    this.terminalsChangeAutoResetEvent.signal();
                }
            }
        }

        public String toString() {
            return "jCardSim Terminal: " + this.name;
        }
    }

    static final class CardTerminalsImpl
    extends CardTerminals {
        private final AtomicBoolean waitCalled = new AtomicBoolean(false);
        private final AutoResetEvent terminalsChangeAutoResetEvent = new AutoResetEvent();
        private final ArrayList<CardTerminalImpl> simulatedTerminals;
        private final HashMap<CardTerminal, CardTerminals.State> terminalStateMap;

        CardTerminalsImpl(String[] names) {
            this.simulatedTerminals = new ArrayList(names.length);
            this.terminalStateMap = new HashMap(names.length);
            for (String name : names) {
                this.simulatedTerminals.add(new CardTerminalImpl(name, this.terminalStateMap, this.terminalsChangeAutoResetEvent));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized List<CardTerminal> list(CardTerminals.State state) throws CardException {
            if (state == null) {
                throw new NullPointerException("state");
            }
            HashMap<CardTerminal, CardTerminals.State> hashMap = this.terminalStateMap;
            synchronized (hashMap) {
                ArrayList<CardTerminal> result = new ArrayList<CardTerminal>(this.simulatedTerminals.size());
                for (CardTerminal cardTerminal : this.simulatedTerminals) {
                    CardTerminals.State terminalState = this.terminalStateMap.get(cardTerminal);
                    switch (state) {
                        case ALL: {
                            result.add(cardTerminal);
                            break;
                        }
                        case CARD_ABSENT: {
                            if (cardTerminal.isCardPresent() || terminalState == CardTerminals.State.CARD_REMOVAL) break;
                            result.add(cardTerminal);
                            break;
                        }
                        case CARD_PRESENT: {
                            if (!cardTerminal.isCardPresent() || terminalState == CardTerminals.State.CARD_INSERTION) break;
                            result.add(cardTerminal);
                            break;
                        }
                        case CARD_INSERTION: {
                            if (this.waitCalled.get()) {
                                if (terminalState != CardTerminals.State.CARD_INSERTION) break;
                                this.terminalStateMap.put(cardTerminal, CardTerminals.State.CARD_PRESENT);
                                result.add(cardTerminal);
                                break;
                            }
                            if (!cardTerminal.isCardPresent()) break;
                            result.add(cardTerminal);
                            break;
                        }
                        case CARD_REMOVAL: {
                            if (this.waitCalled.get()) {
                                if (terminalState != CardTerminals.State.CARD_REMOVAL) break;
                                this.terminalStateMap.put(cardTerminal, CardTerminals.State.CARD_ABSENT);
                                result.add(cardTerminal);
                                break;
                            }
                            if (cardTerminal.isCardPresent()) break;
                            result.add(cardTerminal);
                        }
                    }
                }
                return Collections.unmodifiableList(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean waitForChange(long timeoutMilliseconds) throws CardException {
            try {
                boolean bl = CardTerminalSimulator.waitForLatch(this.terminalsChangeAutoResetEvent, timeoutMilliseconds);
                return bl;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                boolean bl = false;
                return bl;
            }
            finally {
                this.waitCalled.set(true);
            }
        }
    }

    public static final class Factory
    extends TerminalFactorySpi {
        private final CardTerminals cardTerminals;

        public Factory(Object params) {
            String[] names;
            if (params == null) {
                names = new String[]{"jCardSim.Terminal"};
            } else if (params instanceof String) {
                names = new String[]{(String)params};
            } else if (params instanceof String[]) {
                names = (String[])params;
            } else {
                throw new IllegalArgumentException("Illegal parameter: " + params);
            }
            this.cardTerminals = CardTerminalSimulator.terminals(names);
        }

        @Override
        protected CardTerminals engineTerminals() {
            return this.cardTerminals;
        }
    }

    public static final class SecurityProvider
    extends Provider {
        public SecurityProvider() {
            super("CardTerminalSimulator", 1.0, "jCardSim Virtual Terminal Provider");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    SecurityProvider.this.put("TerminalFactory.CardTerminalSimulator", Factory.class.getCanonicalName().replace(".Factory", "$Factory"));
                    return null;
                }
            });
        }
    }
}

