/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.samples;

import com.licel.jcardsim.samples.BaseApplet;
import javacard.framework.APDU;
import javacard.framework.ISOException;
import javacard.security.AESKey;
import javacard.security.Key;
import javacard.security.KeyBuilder;
import javacard.security.RandomData;

public class PersistentApplet
extends BaseApplet {
    private final byte GET_DATA_INS = 1;
    private final byte GET_COUNTER = (byte)2;
    private final byte INC_COUNTER = (byte)3;
    private final byte GET_DESELECT_COUNTER = (byte)4;
    private final short ARR_SIZE = (short)8;
    private final short AES_KEY_SIZE = (short)128;
    private byte[] byteArr;
    private Key[] keyArr;
    private byte counter = 0;
    private byte deSelectCounter = 0;
    RandomData gen = RandomData.getInstance((byte)2);

    protected PersistentApplet(byte[] bArray, short bOffset, byte bLength) {
        this.byteArr = new byte[8];
        this.gen.generateData(this.byteArr, (short)0, (short)this.byteArr.length);
        this.keyArr = new Key[8];
        byte[] keyDataBuf = new byte[16];
        for (int i = 0; i < this.keyArr.length; ++i) {
            this.keyArr[i] = KeyBuilder.buildKey((byte)15, (short)128, false);
            this.gen.generateData(keyDataBuf, (short)0, (short)keyDataBuf.length);
            ((AESKey)this.keyArr[i]).setKey(keyDataBuf, (short)0);
        }
        this.register();
    }

    public static void install(byte[] bArray, short bOffset, byte bLength) throws ISOException {
        new PersistentApplet(bArray, bOffset, bLength);
    }

    @Override
    public void deselect() {
        this.deSelectCounter = (byte)(this.deSelectCounter + 1);
    }

    @Override
    public void process(APDU apdu) {
        if (this.selectingApplet()) {
            return;
        }
        byte[] buffer = apdu.getBuffer();
        switch (buffer[1]) {
            case 1: {
                apdu.setOutgoing();
                short totalLen = (short)(this.byteArr.length + this.keyArr.length * 128 / 8);
                apdu.setOutgoingLength(totalLen);
                byte[] buf = new byte[totalLen];
                System.arraycopy(this.byteArr, 0, buf, 0, this.byteArr.length);
                for (int i = 0; i < this.keyArr.length; ++i) {
                    ((AESKey)this.keyArr[i]).getKey(buf, (short)(this.byteArr.length + i * 128 / 8));
                }
                apdu.sendBytesLong(buf, (short)0, (short)buf.length);
                break;
            }
            case 2: {
                buffer[0] = this.counter;
                apdu.setOutgoingAndSend((short)0, (short)1);
                break;
            }
            case 3: {
                this.counter = (byte)(this.counter + 1);
                break;
            }
            case 4: {
                buffer[0] = this.deSelectCounter;
                apdu.setOutgoingAndSend((short)0, (short)1);
                break;
            }
            default: {
                ISOException.throwIt((short)27904);
            }
        }
    }
}

