/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.samples;

import com.licel.jcardsim.samples.BaseApplet;
import javacard.framework.APDU;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.Util;

public class HelloWorldApplet
extends BaseApplet {
    private static final byte SAY_HELLO_INS = 1;
    private static final byte SAY_ECHO2_INS = 3;
    private static final byte SAY_IPARAMS_INS = 4;
    private static final byte NOP_INS = 2;
    private static final byte SAY_CONTINUE_INS = 6;
    private static final byte LIST_OBJECTS_INS = 88;
    private static final byte APPLICATION_SPECIFIC_SW_INS = 7;
    private static final byte MAXIMUM_DATA_INS = 8;
    private static byte[] helloMessage = new byte[]{72, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100, 32, 33};
    private byte[] echoBytes = new byte[256];
    private byte[] initParamsBytes;
    private final byte[] transientMemory;
    private static final short LENGTH_ECHO_BYTES = 256;

    protected HelloWorldApplet(byte[] bArray, short bOffset, byte bLength) {
        if (bLength > 0) {
            byte iLen = bArray[bOffset];
            bOffset = (short)(bOffset + iLen + 1);
            byte cLen = bArray[bOffset];
            bOffset = (short)(bOffset + 3);
            byte aLen = bArray[bOffset];
            this.initParamsBytes = new byte[aLen];
            Util.arrayCopyNonAtomic(bArray, (short)(bOffset + 1), this.initParamsBytes, (short)0, aLen);
        }
        this.transientMemory = JCSystem.makeTransientByteArray((short)256, (byte)1);
        this.register();
    }

    public static void install(byte[] bArray, short bOffset, byte bLength) throws ISOException {
        new HelloWorldApplet(bArray, bOffset, bLength);
    }

    @Override
    public void process(APDU apdu) {
        if (this.selectingApplet()) {
            return;
        }
        byte[] buffer = apdu.getBuffer();
        switch (buffer[1]) {
            case 1: {
                this.sayHello(apdu, (short)-28672);
                return;
            }
            case 3: {
                this.sayEcho2(apdu);
                return;
            }
            case 4: {
                this.sayIParams(apdu);
                return;
            }
            case 6: {
                this.sayContinue(apdu);
                return;
            }
            case 88: {
                this.listObjects(apdu);
                return;
            }
            case 7: {
                this.sayHello(apdu, (short)-25856);
                return;
            }
            case 8: {
                this.maximumData(apdu);
                return;
            }
            case 2: {
                return;
            }
        }
        ISOException.throwIt((short)27904);
    }

    private void sayHello(APDU apdu, short sw) {
        short echoLength;
        byte[] buffer = apdu.getBuffer();
        short incomeBytes = apdu.setIncomingAndReceive();
        byte[] echo = this.transientMemory;
        if (buffer[2] == 1) {
            echoLength = incomeBytes;
            Util.arrayCopyNonAtomic(buffer, (short)5, echo, (short)0, incomeBytes);
        } else {
            echoLength = (short)helloMessage.length;
            Util.arrayCopyNonAtomic(helloMessage, (short)0, echo, (short)0, (short)helloMessage.length);
        }
        apdu.setOutgoing();
        apdu.setOutgoingLength(echoLength);
        apdu.sendBytesLong(echo, (short)0, echoLength);
        if (sw != 36864) {
            ISOException.throwIt(sw);
        }
    }

    private void sayEcho2(APDU apdu) {
        byte[] buffer = apdu.getBuffer();
        short bytesRead = apdu.setIncomingAndReceive();
        short echoOffset = 0;
        while (bytesRead > 0) {
            Util.arrayCopyNonAtomic(buffer, (short)5, this.echoBytes, echoOffset, bytesRead);
            echoOffset = (short)(echoOffset + bytesRead);
            bytesRead = apdu.receiveBytes((short)5);
        }
        apdu.setOutgoing();
        apdu.setOutgoingLength(echoOffset);
        apdu.sendBytesLong(this.echoBytes, (short)0, echoOffset);
    }

    private void sayIParams(APDU apdu) {
        apdu.setOutgoing();
        apdu.setOutgoingLength((short)this.initParamsBytes.length);
        apdu.sendBytesLong(this.initParamsBytes, (short)0, (short)this.initParamsBytes.length);
    }

    private void sayContinue(APDU apdu) {
        byte[] echo = this.transientMemory;
        short echoLength = 6;
        Util.arrayCopyNonAtomic(helloMessage, (short)0, echo, (short)0, (short)6);
        apdu.setOutgoing();
        apdu.setOutgoingLength(echoLength);
        apdu.sendBytesLong(echo, (short)0, echoLength);
        ISOException.throwIt((short)24839);
    }

    private void maximumData(APDU apdu) {
        short maxData = APDU.getOutBlockSize();
        byte[] buffer = apdu.getBuffer();
        Util.arrayFillNonAtomic(buffer, (short)0, maxData, (byte)0);
        apdu.setOutgoingAndSend((short)0, maxData);
    }

    private void listObjects(APDU apdu) {
        byte expectedBytes;
        byte[] buffer = apdu.getBuffer();
        if (buffer[3] != 0) {
            ISOException.throwIt((short)-25583);
        }
        if ((expectedBytes = buffer[4]) < 14) {
            ISOException.throwIt((short)26368);
        }
        ISOException.throwIt((short)-25582);
    }
}

