/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.TimeUnit;

public class VSmartCardTCPProtocol {
    private Socket socket;
    private InputStream dataInput;
    private OutputStream dataOutput;
    private int frameLen = -1;
    public static final int POWER_OFF = 0;
    public static final int POWER_ON = 1;
    public static final int RESET = 2;
    public static final int GET_ATR = 4;
    public static final int APDU = -1;

    public void connect(String host, int port) throws IOException {
        this.socket = new Socket(host, port);
        try {
            TimeUnit.SECONDS.sleep(3L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.dataInput = this.socket.getInputStream();
        this.dataOutput = this.socket.getOutputStream();
    }

    public void disconnect() {
        this.closeSocket(this.socket);
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public int readCommand() throws IOException {
        byte[] cmdBuf = new byte[3];
        this.read(cmdBuf, 0, 2, this.dataInput);
        int len = cmdBuf[0] << 8 & 0xFF00 | cmdBuf[1] & 0xFF;
        if (len == 1) {
            this.read(cmdBuf, 2, 1, this.dataInput);
            byte cmd = cmdBuf[2];
            return cmd;
        }
        this.frameLen = len;
        return -1;
    }

    public byte[] readData() throws IOException {
        if (this.frameLen == -1) {
            throw new IOException("No APDU command waiting");
        }
        byte[] buf = new byte[this.frameLen];
        this.read(buf, this.dataInput);
        this.frameLen = -1;
        return buf;
    }

    public void writeData(byte[] data) throws IOException {
        byte[] buf = new byte[2 + data.length];
        buf[0] = (byte)((data.length & 0xFF00) >> 8 & 0xFF);
        buf[1] = (byte)(data.length & 0xFF);
        System.arraycopy(data, 0, buf, 2, data.length);
        this.dataOutput.write(buf);
    }

    private void closeSocket(Socket sock) {
        try {
            sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void read(byte[] buf, InputStream stream) throws IOException {
        this.read(buf, 0, buf.length, stream);
    }

    private void read(byte[] buf, int offset, int len, InputStream stream) throws IOException {
        while (len > 0) {
            int retval = stream.read(buf, offset, len);
            if (retval < 0) {
                throw new IOException("Got negative number from socket");
            }
            len -= retval;
            offset += retval;
        }
    }
}

