/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.remote;

import com.licel.jcardsim.base.CardManager;
import com.licel.jcardsim.base.Simulator;
import com.licel.jcardsim.base.SimulatorRuntime;
import com.licel.jcardsim.remote.VSmartCardTCPProtocol;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.InvalidParameterException;
import java.util.Enumeration;
import java.util.Properties;

public class VSmartCard {
    static final String RELOADER_PORT_PROPERTY = "com.licel.jcardsim.vsmartcard.reloader.port";
    static final String RELOADER_PORT_DEFAULT = "8099";
    static final String RELOADER_DELAY_PROPERTY = "com.licel.jcardsim.vsmartcard.reloader.delay";
    static final String RELOADER_DELAY_DEFAULT = "1000";
    Simulator sim;
    ReloadThread reloader;

    public VSmartCard(String host, int port) throws IOException {
        VSmartCardTCPProtocol driverProtocol = new VSmartCardTCPProtocol();
        driverProtocol.connect(host, port);
        this.startThread(driverProtocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: java com.licel.jcardsim.remote.VSmartCard <jcardsim.cfg>");
            System.exit(-1);
        }
        Properties cfg = new Properties();
        try (FileInputStream fis = null;){
            fis = new FileInputStream(args[0]);
            cfg.load(fis);
        }
        System.setProperty("com.licel.jcardsim.card.ATR", cfg.getProperty("com.licel.jcardsim.card.ATR", "3BFA1800008131FE454A434F5033315632333298"));
        System.setProperty(RELOADER_PORT_PROPERTY, cfg.getProperty(RELOADER_PORT_PROPERTY, RELOADER_PORT_DEFAULT));
        System.setProperty(RELOADER_DELAY_PROPERTY, cfg.getProperty(RELOADER_DELAY_PROPERTY, RELOADER_DELAY_DEFAULT));
        Enumeration<?> keys = cfg.propertyNames();
        while (keys.hasMoreElements()) {
            String propertyName = (String)keys.nextElement();
            System.setProperty(propertyName, cfg.getProperty(propertyName));
        }
        String propKey = "com.licel.jcardsim.vsmartcard.host";
        String host = System.getProperty(propKey);
        if (host == null) {
            throw new InvalidParameterException("Missing value for property: " + propKey);
        }
        propKey = "com.licel.jcardsim.vsmartcard.port";
        String port = System.getProperty(propKey);
        if (port == null) {
            throw new InvalidParameterException("Missing value for property: " + propKey);
        }
        new VSmartCard(host, Integer.parseInt(port));
    }

    private void startThread(VSmartCardTCPProtocol driverProtocol) throws IOException {
        SimulatorRuntime simRuntime;
        System.out.println("Trying to load an instance of com.licel.globalplatform.GpSimulatorRuntime");
        try {
            simRuntime = (SimulatorRuntime)Class.forName("com.licel.globalplatform.GpSimulatorRuntime").newInstance();
            System.out.println("Succesfully loaded the instance!");
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.err);
            System.out.println("Failed to load the instance! Will use the default SimulatorRuntime");
            simRuntime = new SimulatorRuntime();
        }
        this.sim = new Simulator(simRuntime);
        IOThread ioThread = new IOThread(this.sim, driverProtocol);
        ShutDownHook hook = new ShutDownHook(ioThread);
        Runtime.getRuntime().addShutdownHook(hook);
        ioThread.start();
        this.reloader = new ReloadThread(hook);
        this.reloader.start();
    }

    static class IOThread
    extends Thread {
        VSmartCardTCPProtocol driverProtocol;
        Simulator sim;
        boolean isRunning;

        public IOThread(Simulator sim, VSmartCardTCPProtocol driverProtocol) {
            this.sim = sim;
            this.driverProtocol = driverProtocol;
            this.isRunning = true;
        }

        private void hexDump(byte[] apdu) {
            for (int i = 0; i < apdu.length; i += 8) {
                int j;
                System.out.printf("%04X:  ", i);
                for (j = i; j < i + 4 && j < apdu.length; ++j) {
                    System.out.printf("%02X ", apdu[j]);
                }
                System.out.printf(" ", new Object[0]);
                for (j = i + 4; j < i + 8 && j < apdu.length; ++j) {
                    System.out.printf("%02X ", apdu[j]);
                }
                System.out.printf("\n", new Object[0]);
            }
        }

        @Override
        public void run() {
            while (this.isRunning) {
                try {
                    int cmd = this.driverProtocol.readCommand();
                    switch (cmd) {
                        case 1: 
                        case 2: {
                            this.sim.reset();
                            break;
                        }
                        case 4: {
                            this.driverProtocol.writeData(this.sim.getATR());
                            break;
                        }
                        case -1: {
                            byte[] apdu = this.driverProtocol.readData();
                            System.out.println("== APDU");
                            this.hexDump(apdu);
                            byte[] reply = CardManager.dispatchApdu(this.sim, apdu);
                            System.out.println("== Reply APDU");
                            this.hexDump(reply);
                            this.driverProtocol.writeData(reply);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                catch (Throwable e) {
                    e.printStackTrace(System.err);
                    throw e;
                }
            }
        }
    }

    static class ReloadThread
    extends Thread {
        ShutDownHook hook;

        public ReloadThread(ShutDownHook hook) {
            this.hook = hook;
        }

        @Override
        public void run() {
            try {
                String port = System.getProperty(VSmartCard.RELOADER_PORT_PROPERTY);
                String delay = System.getProperty(VSmartCard.RELOADER_DELAY_PROPERTY);
                try {
                    String newConfig;
                    boolean isPowerOffCmd = false;
                    do {
                        try (ServerSocket serverSocket = new ServerSocket(Integer.parseInt(port));){
                            System.out.println("Start reloader server on port " + port);
                            try (Socket socket = serverSocket.accept();
                                 BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));){
                                newConfig = reader.readLine();
                                System.out.println("Got a new config: " + newConfig);
                                isPowerOffCmd = "0".equalsIgnoreCase(reader.readLine());
                                System.out.println("isPowerOffCmd: " + isPowerOffCmd);
                            }
                        }
                        if (this.hook.ioThread.driverProtocol.isClosed()) continue;
                        Runtime.getRuntime().removeShutdownHook(this.hook);
                        this.hook.start();
                        while (!this.hook.ioThread.driverProtocol.isClosed()) {
                            Thread.sleep(100L);
                        }
                        System.out.println("Card remove delay: " + delay + "...");
                        Thread.sleep(Integer.parseInt(delay));
                    } while (isPowerOffCmd);
                    VSmartCard.main(new String[]{newConfig});
                }
                catch (InterruptedException ignore) {
                    ignore.printStackTrace(System.err);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
                throw e;
            }
        }
    }

    static class ShutDownHook
    extends Thread {
        IOThread ioThread;

        public ShutDownHook(IOThread ioThread) {
            this.ioThread = ioThread;
        }

        @Override
        public void run() {
            this.ioThread.isRunning = false;
            System.out.println("Shutdown connections");
            this.ioThread.driverProtocol.disconnect();
        }
    }
}

