/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.esotericsoftware.kryo.serializers;

import com.licel.jcardsim.esotericsoftware.kryo.Kryo;
import com.licel.jcardsim.esotericsoftware.kryo.KryoException;
import com.licel.jcardsim.esotericsoftware.kryo.Serializer;
import com.licel.jcardsim.esotericsoftware.kryo.io.Input;
import com.licel.jcardsim.esotericsoftware.kryo.io.Output;
import com.licel.jcardsim.esotericsoftware.kryo.util.Util;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;

public class ClosureSerializer
extends Serializer {
    private static Method readResolve;

    public ClosureSerializer() {
        if (readResolve == null) {
            try {
                readResolve = SerializedLambda.class.getDeclaredMethod("readResolve", new Class[0]);
                readResolve.setAccessible(true);
            }
            catch (Exception ex) {
                throw new KryoException("Unable to obtain SerializedLambda#readResolve via reflection.", ex);
            }
        }
    }

    public void write(Kryo kryo, Output output, Object object) {
        SerializedLambda serializedLambda = this.toSerializedLambda(object);
        int count = serializedLambda.getCapturedArgCount();
        output.writeVarInt(count, true);
        for (int i = 0; i < count; ++i) {
            kryo.writeClassAndObject(output, serializedLambda.getCapturedArg(i));
        }
        try {
            kryo.writeClass(output, Class.forName(serializedLambda.getCapturingClass().replace('/', '.')));
        }
        catch (ClassNotFoundException ex) {
            throw new KryoException("Error writing closure.", ex);
        }
        output.writeString(serializedLambda.getFunctionalInterfaceClass());
        output.writeString(serializedLambda.getFunctionalInterfaceMethodName());
        output.writeString(serializedLambda.getFunctionalInterfaceMethodSignature());
        output.writeVarInt(serializedLambda.getImplMethodKind(), true);
        output.writeString(serializedLambda.getImplClass());
        output.writeString(serializedLambda.getImplMethodName());
        output.writeString(serializedLambda.getImplMethodSignature());
        output.writeString(serializedLambda.getInstantiatedMethodType());
    }

    public Object read(Kryo kryo, Input input, Class type) {
        int count = input.readVarInt(true);
        Object[] capturedArgs = new Object[count];
        for (int i = 0; i < count; ++i) {
            capturedArgs[i] = kryo.readClassAndObject(input);
        }
        SerializedLambda serializedLambda = new SerializedLambda(kryo.readClass(input).getType(), input.readString(), input.readString(), input.readString(), input.readVarInt(true), input.readString(), input.readString(), input.readString(), input.readString(), capturedArgs);
        try {
            return readResolve.invoke((Object)serializedLambda, new Object[0]);
        }
        catch (Exception ex) {
            throw new KryoException("Error reading closure.", ex);
        }
    }

    public Object copy(Kryo kryo, Object original) {
        try {
            return readResolve.invoke((Object)this.toSerializedLambda(original), new Object[0]);
        }
        catch (Exception ex) {
            throw new KryoException("Error copying closure.", ex);
        }
    }

    private SerializedLambda toSerializedLambda(Object object) {
        Object replacement;
        try {
            Method writeReplace = object.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            replacement = writeReplace.invoke(object, new Object[0]);
        }
        catch (Exception ex) {
            if (object instanceof Serializable) {
                throw new KryoException("Error serializing closure.", ex);
            }
            throw new KryoException("Closure must implement java.io.Serializable.", ex);
        }
        try {
            return (SerializedLambda)replacement;
        }
        catch (Exception ex) {
            throw new KryoException("writeReplace must return a SerializedLambda: " + (replacement == null ? null : Util.className(replacement.getClass())), ex);
        }
    }

    public static class Closure {
    }
}

