/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.bouncycastle.crypto.CipherParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DHKeyParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DHParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.DHKeyImpl;
import javacard.security.CryptoException;
import javacard.security.DHPublicKey;

public final class DHPublicKeyImpl
extends DHKeyImpl
implements DHPublicKey {
    protected ByteContainer y = new ByteContainer();

    public DHPublicKeyImpl(short size) {
        this.size = size;
        this.type = (byte)32;
    }

    public DHPublicKeyImpl(DHKeyParameters params) {
        this.setParameters(params);
    }

    @Override
    public void setParameters(CipherParameters params) {
        super.setParameters(((DHPublicKeyParameters)params).getParameters());
        this.y.setBigInteger(((DHPublicKeyParameters)params).getY());
    }

    @Override
    public void setY(byte[] bytes, short offset, short length) throws CryptoException {
        this.y.setBytes(bytes, offset, length);
    }

    @Override
    public short getY(byte[] bytes, short offset) {
        return this.y.getBytes(bytes, offset);
    }

    @Override
    public void clearKey() {
        super.clearKey();
        this.y.clear();
    }

    @Override
    public boolean isInitialized() {
        return super.isInitialized() && this.y.isInitialized();
    }

    @Override
    public CipherParameters getParameters() {
        if (!this.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        return new DHPublicKeyParameters(this.y.getBigInteger(), (DHParameters)super.getParameters());
    }
}

