/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.bouncycastle.crypto.Digest;

public class BouncyCastlePrecomputedOrDigestProxy
implements Digest {
    private final Digest parentDigest;
    private byte[] precomputedDigestValue = null;

    public BouncyCastlePrecomputedOrDigestProxy(Digest parentDigest) {
        this.parentDigest = parentDigest;
    }

    @Override
    public String getAlgorithmName() {
        return this.parentDigest.getAlgorithmName();
    }

    @Override
    public int getDigestSize() {
        return this.parentDigest.getDigestSize();
    }

    @Override
    public void update(byte in) {
        if (this.precomputedDigestValue == null) {
            this.parentDigest.update(in);
        }
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        if (this.precomputedDigestValue == null) {
            this.parentDigest.update(in, inOff, len);
        }
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        if (this.precomputedDigestValue == null) {
            return this.parentDigest.doFinal(out, outOff);
        }
        System.arraycopy(this.precomputedDigestValue, 0, out, outOff, this.precomputedDigestValue.length);
        int len = this.precomputedDigestValue.length;
        this.precomputedDigestValue = null;
        return len;
    }

    public void setPrecomputedValue(byte[] in, int inOff, int inLength) {
        int digestSize = this.getDigestSize();
        if (inLength != digestSize) {
            throw new IllegalArgumentException();
        }
        this.precomputedDigestValue = new byte[digestSize];
        System.arraycopy(in, inOff, this.precomputedDigestValue, 0, digestSize);
    }

    @Override
    public void reset() {
        this.precomputedDigestValue = null;
        this.parentDigest.reset();
    }
}

