/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.bouncycastle.asn1.ASN1EncodableVector;
import com.licel.jcardsim.bouncycastle.asn1.ASN1Integer;
import com.licel.jcardsim.bouncycastle.asn1.DERSequence;
import com.licel.jcardsim.bouncycastle.crypto.AsymmetricBlockCipher;
import com.licel.jcardsim.bouncycastle.crypto.DSA;
import com.licel.jcardsim.bouncycastle.crypto.DataLengthException;
import com.licel.jcardsim.bouncycastle.crypto.Digest;
import com.licel.jcardsim.bouncycastle.crypto.Signer;
import com.licel.jcardsim.bouncycastle.crypto.SignerWithRecovery;
import com.licel.jcardsim.bouncycastle.crypto.digests.MD5Digest;
import com.licel.jcardsim.bouncycastle.crypto.digests.RIPEMD160Digest;
import com.licel.jcardsim.bouncycastle.crypto.digests.SHA1Digest;
import com.licel.jcardsim.bouncycastle.crypto.digests.SHA224Digest;
import com.licel.jcardsim.bouncycastle.crypto.digests.SHA256Digest;
import com.licel.jcardsim.bouncycastle.crypto.digests.SHA384Digest;
import com.licel.jcardsim.bouncycastle.crypto.digests.SHA512Digest;
import com.licel.jcardsim.bouncycastle.crypto.engines.RSAEngine;
import com.licel.jcardsim.bouncycastle.crypto.params.ParametersWithRandom;
import com.licel.jcardsim.bouncycastle.crypto.signers.DSADigestSigner;
import com.licel.jcardsim.bouncycastle.crypto.signers.ECDSASigner;
import com.licel.jcardsim.bouncycastle.crypto.signers.ISO9796d2Signer;
import com.licel.jcardsim.bouncycastle.crypto.signers.PSSSigner;
import com.licel.jcardsim.bouncycastle.crypto.signers.RSADigestSigner;
import com.licel.jcardsim.crypto.BouncyCastlePrecomputedOrDigestProxy;
import com.licel.jcardsim.crypto.KeyWithParameters;
import com.licel.jcardsim.crypto.SecureRandomNullProvider;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.CryptoException;
import javacard.security.Key;
import javacard.security.Signature;
import javacard.security.SignatureMessageRecovery;

public class AsymmetricSignatureImpl
extends Signature
implements SignatureMessageRecovery {
    Signer engine;
    Key key;
    byte algorithm;
    boolean isInitialized;
    boolean isRecovery;
    byte[] preSig;
    DSA dsaImpl;

    public AsymmetricSignatureImpl(byte algorithm) {
        this.algorithm = algorithm;
        this.isRecovery = false;
        switch (algorithm) {
            case 9: {
                this.engine = new ISO9796d2Signer(new RSAEngine(), new SHA1Digest());
                break;
            }
            case 30: {
                this.engine = new ISO9796d2Signer(new RSAEngine(), new SHA1Digest(), true);
                this.isRecovery = true;
                break;
            }
            case 10: {
                this.engine = new RSADigestSigner(new BouncyCastlePrecomputedOrDigestProxy(new SHA1Digest()));
                break;
            }
            case 39: {
                this.engine = new RSADigestSigner(new BouncyCastlePrecomputedOrDigestProxy(new SHA224Digest()));
                break;
            }
            case 40: {
                this.engine = new RSADigestSigner(new BouncyCastlePrecomputedOrDigestProxy(new SHA256Digest()));
                break;
            }
            case 41: {
                this.engine = new RSADigestSigner(new BouncyCastlePrecomputedOrDigestProxy(new SHA384Digest()));
                break;
            }
            case 42: {
                this.engine = new RSADigestSigner(new BouncyCastlePrecomputedOrDigestProxy(new SHA512Digest()));
                break;
            }
            case 21: {
                this.engine = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(new SHA1Digest()), 16);
                break;
            }
            case 43: {
                this.engine = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(new SHA224Digest()), 28);
                break;
            }
            case 44: {
                this.engine = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(new SHA256Digest()), 32);
                break;
            }
            case 45: {
                this.engine = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(new SHA384Digest()), 48);
                break;
            }
            case 46: {
                this.engine = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(new SHA512Digest()), 64);
                break;
            }
            case 11: {
                this.engine = new RSADigestSigner(new BouncyCastlePrecomputedOrDigestProxy(new MD5Digest()));
                break;
            }
            case 12: {
                this.engine = new ISO9796d2Signer(new RSAEngine(), new RIPEMD160Digest());
                break;
            }
            case 13: {
                this.engine = new RSADigestSigner(new BouncyCastlePrecomputedOrDigestProxy(new RIPEMD160Digest()));
                break;
            }
            case 17: {
                this.engine = new DSADigestSigner(new ECDSASigner(), new BouncyCastlePrecomputedOrDigestProxy(new SHA1Digest()));
                break;
            }
            case 37: {
                this.engine = new DSADigestSigner(new ECDSASigner(), new BouncyCastlePrecomputedOrDigestProxy(new SHA224Digest()));
                break;
            }
            case 33: {
                this.engine = new DSADigestSigner(new ECDSASigner(), new BouncyCastlePrecomputedOrDigestProxy(new SHA256Digest()));
                break;
            }
            case 34: {
                this.engine = new DSADigestSigner(new ECDSASigner(), new BouncyCastlePrecomputedOrDigestProxy(new SHA384Digest()));
                break;
            }
            case 38: {
                this.engine = new DSADigestSigner(new ECDSASigner(), new BouncyCastlePrecomputedOrDigestProxy(new SHA512Digest()));
            }
        }
    }

    @Override
    public void init(Key theKey, byte theMode) throws CryptoException {
        if (theKey == null) {
            CryptoException.throwIt((short)2);
        }
        if (!theKey.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        if (!(theKey instanceof KeyWithParameters)) {
            CryptoException.throwIt((short)1);
        }
        if (this.engine instanceof ISO9796d2Signer || theMode != 1) {
            KeyWithParameters key = (KeyWithParameters)((Object)theKey);
            this.engine.init(theMode == 1, key.getParameters());
        } else {
            ParametersWithRandom params = new ParametersWithRandom(((KeyWithParameters)((Object)theKey)).getParameters(), new SecureRandomNullProvider());
            this.engine.init(theMode == 1, params);
        }
        this.key = theKey;
        this.isInitialized = true;
    }

    @Override
    public void init(Key theKey, byte theMode, byte[] bArray, short bOff, short bLen) throws CryptoException {
        CryptoException.throwIt((short)1);
    }

    @Override
    public short getLength() throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        if (!this.key.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        switch (this.algorithm) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return (short)(this.key.getSize() >> 3);
            }
            case 17: 
            case 33: 
            case 34: 
            case 37: 
            case 38: {
                return (short)((this.key.getSize() * 2 >> 3) + 8);
            }
        }
        return 0;
    }

    @Override
    public byte getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void update(byte[] inBuff, short inOffset, short inLength) throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.engine.update(inBuff, inOffset, inLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short sign(byte[] inBuff, short inOffset, short inLength, byte[] sigBuff, short sigOffset) throws CryptoException {
        if (this.isRecovery) {
            CryptoException.throwIt((short)5);
        }
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.engine.update(inBuff, inOffset, inLength);
        try {
            byte[] sig = this.engine.generateSignature();
            Util.arrayCopyNonAtomic(sig, (short)0, sigBuff, sigOffset, (short)sig.length);
            short s = (short)sig.length;
            return s;
        }
        catch (com.licel.jcardsim.bouncycastle.crypto.CryptoException ex) {
            CryptoException.throwIt((short)5);
        }
        catch (DataLengthException ex) {
            CryptoException.throwIt((short)1);
        }
        finally {
            this.engine.reset();
        }
        return -1;
    }

    @Override
    public boolean verify(byte[] inBuff, short inOffset, short inLength, byte[] sigBuff, short sigOffset, short sigLength) throws CryptoException {
        if (this.isRecovery) {
            CryptoException.throwIt((short)5);
        }
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.engine.update(inBuff, inOffset, inLength);
        byte[] sig = new byte[sigLength];
        Util.arrayCopyNonAtomic(sigBuff, sigOffset, sig, (short)0, sigLength);
        boolean b = this.engine.verifySignature(sig);
        this.engine.reset();
        return b;
    }

    @Override
    public short beginVerify(byte[] sigAndRecDataBuff, short buffOffset, short sigLength) throws CryptoException {
        if (!this.isRecovery) {
            CryptoException.throwIt((short)5);
        }
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.preSig = JCSystem.makeTransientByteArray(sigLength, (byte)1);
        Util.arrayCopyNonAtomic(sigAndRecDataBuff, buffOffset, this.preSig, (short)0, sigLength);
        try {
            ((SignerWithRecovery)this.engine).updateWithRecoveredMessage(this.preSig);
            return (short)((SignerWithRecovery)this.engine).getRecoveredMessage().length;
        }
        catch (Exception ex) {
            CryptoException.throwIt((short)1);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short sign(byte[] inBuff, short inOffset, short inLength, byte[] sigBuff, short sigOffset, short[] recMsgLen, short recMsgLenOffset) throws CryptoException {
        if (!this.isRecovery) {
            CryptoException.throwIt((short)5);
        }
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.engine.update(inBuff, inOffset, inLength);
        try {
            byte[] sig = this.engine.generateSignature();
            Util.arrayCopyNonAtomic(sig, (short)0, sigBuff, sigOffset, (short)sig.length);
            recMsgLen[recMsgLenOffset] = (short)((SignerWithRecovery)this.engine).getRecoveredMessage().length;
            short s = (short)sig.length;
            return s;
        }
        catch (com.licel.jcardsim.bouncycastle.crypto.CryptoException ex) {
            CryptoException.throwIt((short)5);
        }
        catch (DataLengthException ex) {
            CryptoException.throwIt((short)1);
        }
        catch (Exception ex) {
            CryptoException.throwIt((short)5);
        }
        finally {
            this.engine.reset();
        }
        return -1;
    }

    @Override
    public boolean verify(byte[] inBuff, short inOffset, short inLength) throws CryptoException {
        if (!this.isRecovery) {
            CryptoException.throwIt((short)5);
        }
        if (this.preSig == null) {
            CryptoException.throwIt((short)5);
        }
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.engine.update(inBuff, inOffset, inLength);
        boolean b = this.engine.verifySignature(this.preSig);
        this.engine.reset();
        return b;
    }

    @Override
    public void setInitialDigest(byte[] bytes, short s, short s1, byte[] bytes1, short s2, short s3) throws CryptoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private byte[] ecSigDerEncode(BigInteger r, BigInteger s) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(r));
        v.add(new ASN1Integer(s));
        return new DERSequence(v).getEncoded();
    }

    @Override
    public short signPreComputedHash(byte[] hashBuff, short hashOffset, short hashLength, byte[] sigBuff, short sigOffset) throws CryptoException {
        try {
            if (this.engine instanceof RSADigestSigner || this.engine instanceof DSADigestSigner || this.engine instanceof PSSSigner) {
                Field h = this.engine.getClass().getDeclaredField(this.engine instanceof PSSSigner ? "contentDigest" : "digest");
                h.setAccessible(true);
                Object digestObject = h.get(this.engine);
                digestObject.getClass().getMethod("setPrecomputedValue", byte[].class, Integer.TYPE, Integer.TYPE).invoke(digestObject, hashBuff, hashOffset, hashLength);
                return this.sign(null, (short)0, (short)0, sigBuff, sigOffset);
            }
        }
        catch (ReflectiveOperationException h) {
            // empty catch block
        }
        try {
            if (this.engine instanceof DSADigestSigner && this.dsaImpl != null) {
                byte[] hash = new byte[hashLength];
                Util.arrayCopyNonAtomic(hashBuff, hashOffset, hash, (short)0, hashLength);
                BigInteger[] sigBi = this.dsaImpl.generateSignature(hash);
                byte[] sig = this.ecSigDerEncode(sigBi[0], sigBi[1]);
                Util.arrayCopyNonAtomic(sig, (short)0, sigBuff, sigOffset, (short)sig.length);
                return (short)sig.length;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        CryptoException.throwIt((short)5);
        return 0;
    }

    @Override
    public boolean verifyPreComputedHash(byte[] hashBuff, short hashOffset, short hashLength, byte[] sigBuff, short sigOffset, short sigLength) throws CryptoException {
        try {
            if (this.engine instanceof RSADigestSigner || this.engine instanceof DSADigestSigner || this.engine instanceof PSSSigner) {
                Field h = this.engine.getClass().getDeclaredField(this.engine instanceof PSSSigner ? "contentDigest" : "digest");
                h.setAccessible(true);
                Object digestObject = h.get(this.engine);
                digestObject.getClass().getMethod("setPrecomputedValue", byte[].class, Integer.TYPE, Integer.TYPE).invoke(digestObject, hashBuff, hashOffset, hashLength);
                return this.verify(null, (short)0, (short)0, sigBuff, sigOffset, sigLength);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        CryptoException.throwIt((short)5);
        return false;
    }

    @Override
    public byte getPaddingAlgorithm() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte getCipherAlgorithm() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte getMessageDigestAlgorithm() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

