/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.math.ec.custom.sec;

import com.licel.jcardsim.bouncycastle.math.ec.ECFieldElement;
import com.licel.jcardsim.bouncycastle.math.ec.custom.sec.SecP224K1Field;
import com.licel.jcardsim.bouncycastle.math.raw.Nat224;
import com.licel.jcardsim.bouncycastle.util.Arrays;
import com.licel.jcardsim.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP224K1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFE56D"));
    private static final int[] PRECOMP_POW2 = new int[]{868209154, -587542221, 579297866, -1014948952, -1470801668, 514782679, -1897982644};
    protected int[] x;

    public SecP224K1FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP224K1FieldElement");
        }
        this.x = SecP224K1Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SecP224K1FieldElement() {
        this.x = Nat224.create();
    }

    protected SecP224K1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat224.isZero((int[])this.x);
    }

    @Override
    public boolean isOne() {
        return Nat224.isOne((int[])this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat224.getBit((int[])this.x, (int)0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat224.toBigInteger((int[])this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP224K1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat224.create();
        SecP224K1Field.add((int[])this.x, (int[])((SecP224K1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP224K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement addOne() {
        int[] nArray = Nat224.create();
        SecP224K1Field.addOne((int[])this.x, (int[])nArray);
        return new SecP224K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat224.create();
        SecP224K1Field.subtract((int[])this.x, (int[])((SecP224K1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP224K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat224.create();
        SecP224K1Field.multiply((int[])this.x, (int[])((SecP224K1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP224K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat224.create();
        SecP224K1Field.inv((int[])((SecP224K1FieldElement)eCFieldElement).x, (int[])nArray);
        SecP224K1Field.multiply((int[])nArray, (int[])this.x, (int[])nArray);
        return new SecP224K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        int[] nArray = Nat224.create();
        SecP224K1Field.negate((int[])this.x, (int[])nArray);
        return new SecP224K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement square() {
        int[] nArray = Nat224.create();
        SecP224K1Field.square((int[])this.x, (int[])nArray);
        return new SecP224K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement invert() {
        int[] nArray = Nat224.create();
        SecP224K1Field.inv((int[])this.x, (int[])nArray);
        return new SecP224K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat224.isZero((int[])nArray) || Nat224.isOne((int[])nArray)) {
            return this;
        }
        int[] nArray2 = Nat224.create();
        SecP224K1Field.square((int[])nArray, (int[])nArray2);
        SecP224K1Field.multiply((int[])nArray2, (int[])nArray, (int[])nArray2);
        int[] nArray3 = nArray2;
        SecP224K1Field.square((int[])nArray2, (int[])nArray3);
        SecP224K1Field.multiply((int[])nArray3, (int[])nArray, (int[])nArray3);
        int[] nArray4 = Nat224.create();
        SecP224K1Field.square((int[])nArray3, (int[])nArray4);
        SecP224K1Field.multiply((int[])nArray4, (int[])nArray, (int[])nArray4);
        int[] nArray5 = Nat224.create();
        SecP224K1Field.squareN((int[])nArray4, (int)4, (int[])nArray5);
        SecP224K1Field.multiply((int[])nArray5, (int[])nArray4, (int[])nArray5);
        int[] nArray6 = Nat224.create();
        SecP224K1Field.squareN((int[])nArray5, (int)3, (int[])nArray6);
        SecP224K1Field.multiply((int[])nArray6, (int[])nArray3, (int[])nArray6);
        int[] nArray7 = nArray6;
        SecP224K1Field.squareN((int[])nArray6, (int)8, (int[])nArray7);
        SecP224K1Field.multiply((int[])nArray7, (int[])nArray5, (int[])nArray7);
        int[] nArray8 = nArray5;
        SecP224K1Field.squareN((int[])nArray7, (int)4, (int[])nArray8);
        SecP224K1Field.multiply((int[])nArray8, (int[])nArray4, (int[])nArray8);
        int[] nArray9 = nArray4;
        SecP224K1Field.squareN((int[])nArray8, (int)19, (int[])nArray9);
        SecP224K1Field.multiply((int[])nArray9, (int[])nArray7, (int[])nArray9);
        int[] nArray10 = Nat224.create();
        SecP224K1Field.squareN((int[])nArray9, (int)42, (int[])nArray10);
        SecP224K1Field.multiply((int[])nArray10, (int[])nArray9, (int[])nArray10);
        int[] nArray11 = nArray9;
        SecP224K1Field.squareN((int[])nArray10, (int)23, (int[])nArray11);
        SecP224K1Field.multiply((int[])nArray11, (int[])nArray8, (int[])nArray11);
        int[] nArray12 = nArray8;
        SecP224K1Field.squareN((int[])nArray11, (int)84, (int[])nArray12);
        SecP224K1Field.multiply((int[])nArray12, (int[])nArray10, (int[])nArray12);
        int[] nArray13 = nArray12;
        SecP224K1Field.squareN((int[])nArray13, (int)20, (int[])nArray13);
        SecP224K1Field.multiply((int[])nArray13, (int[])nArray7, (int[])nArray13);
        SecP224K1Field.squareN((int[])nArray13, (int)3, (int[])nArray13);
        SecP224K1Field.multiply((int[])nArray13, (int[])nArray, (int[])nArray13);
        SecP224K1Field.squareN((int[])nArray13, (int)2, (int[])nArray13);
        SecP224K1Field.multiply((int[])nArray13, (int[])nArray, (int[])nArray13);
        SecP224K1Field.squareN((int[])nArray13, (int)4, (int[])nArray13);
        SecP224K1Field.multiply((int[])nArray13, (int[])nArray3, (int[])nArray13);
        SecP224K1Field.square((int[])nArray13, (int[])nArray13);
        int[] nArray14 = nArray10;
        SecP224K1Field.square((int[])nArray13, (int[])nArray14);
        if (Nat224.eq((int[])nArray, (int[])nArray14)) {
            return new SecP224K1FieldElement(nArray13);
        }
        SecP224K1Field.multiply((int[])nArray13, (int[])PRECOMP_POW2, (int[])nArray13);
        SecP224K1Field.square((int[])nArray13, (int[])nArray14);
        if (Nat224.eq((int[])nArray, (int[])nArray14)) {
            return new SecP224K1FieldElement(nArray13);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecP224K1FieldElement)) {
            return false;
        }
        SecP224K1FieldElement secP224K1FieldElement = (SecP224K1FieldElement)object;
        return Nat224.eq((int[])this.x, (int[])secP224K1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 7);
    }
}

