/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.math.ec.custom.sec;

import com.licel.jcardsim.bouncycastle.math.ec.ECConstants;
import com.licel.jcardsim.bouncycastle.math.ec.ECCurve;
import com.licel.jcardsim.bouncycastle.math.ec.ECFieldElement;
import com.licel.jcardsim.bouncycastle.math.ec.ECLookupTable;
import com.licel.jcardsim.bouncycastle.math.ec.ECPoint;
import com.licel.jcardsim.bouncycastle.math.ec.custom.sec.SecP192R1Field;
import com.licel.jcardsim.bouncycastle.math.ec.custom.sec.SecP192R1FieldElement;
import com.licel.jcardsim.bouncycastle.math.ec.custom.sec.SecP192R1Point;
import com.licel.jcardsim.bouncycastle.math.raw.Nat192;
import com.licel.jcardsim.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP192R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = SecP192R1FieldElement.Q;
    private static final int SECP192R1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP192R1_AFFINE_ZS = new ECFieldElement[]{new SecP192R1FieldElement(ECConstants.ONE)};
    protected SecP192R1Point infinity = new SecP192R1Point((ECCurve)this, null, null);

    public SecP192R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("64210519E59C80E70FA7E9AB72243049FEB8DEECC146B9B1")));
        this.order = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFF99DEF836146BC9B1B4D22831"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SecP192R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP192R1FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP192R1Point((ECCurve)this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP192R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, int n2) {
        int[] nArray = new int[n2 * 6 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            Nat192.copy((int[])((SecP192R1FieldElement)eCPoint.getRawXCoord()).x, (int)0, (int[])nArray, (int)n3);
            Nat192.copy((int[])((SecP192R1FieldElement)eCPoint.getRawYCoord()).x, (int)0, (int[])nArray, (int)(n3 += 6));
            n3 += 6;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat192.create();
        SecP192R1Field.random((SecureRandom)secureRandom, (int[])nArray);
        return new SecP192R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat192.create();
        SecP192R1Field.randomMult((SecureRandom)secureRandom, (int[])nArray);
        return new SecP192R1FieldElement(nArray);
    }

    static /* synthetic */ ECFieldElement[] access$000() {
        return SECP192R1_AFFINE_ZS;
    }
}

