/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.math.ec.custom.gm;

import com.licel.jcardsim.bouncycastle.math.ec.ECConstants;
import com.licel.jcardsim.bouncycastle.math.ec.ECCurve;
import com.licel.jcardsim.bouncycastle.math.ec.ECFieldElement;
import com.licel.jcardsim.bouncycastle.math.ec.ECLookupTable;
import com.licel.jcardsim.bouncycastle.math.ec.ECPoint;
import com.licel.jcardsim.bouncycastle.math.ec.custom.gm.SM2P256V1Field;
import com.licel.jcardsim.bouncycastle.math.ec.custom.gm.SM2P256V1FieldElement;
import com.licel.jcardsim.bouncycastle.math.ec.custom.gm.SM2P256V1Point;
import com.licel.jcardsim.bouncycastle.math.raw.Nat256;
import com.licel.jcardsim.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SM2P256V1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = SM2P256V1FieldElement.Q;
    private static final int SM2P256V1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SM2P256V1_AFFINE_ZS = new ECFieldElement[]{new SM2P256V1FieldElement(ECConstants.ONE)};
    protected SM2P256V1Point infinity = new SM2P256V1Point((ECCurve)this, null, null);

    public SM2P256V1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93")));
        this.order = new BigInteger(1, Hex.decodeStrict("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SM2P256V1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SM2P256V1FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SM2P256V1Point((ECCurve)this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SM2P256V1Point((ECCurve)this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, int n2) {
        int[] nArray = new int[n2 * 8 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            Nat256.copy((int[])((SM2P256V1FieldElement)eCPoint.getRawXCoord()).x, (int)0, (int[])nArray, (int)n3);
            Nat256.copy((int[])((SM2P256V1FieldElement)eCPoint.getRawYCoord()).x, (int)0, (int[])nArray, (int)(n3 += 8));
            n3 += 8;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        SM2P256V1Field.random((SecureRandom)secureRandom, (int[])nArray);
        return new SM2P256V1FieldElement(nArray);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        SM2P256V1Field.randomMult((SecureRandom)secureRandom, (int[])nArray);
        return new SM2P256V1FieldElement(nArray);
    }

    static /* synthetic */ ECFieldElement[] access$000() {
        return SM2P256V1_AFFINE_ZS;
    }
}

