/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.asn1;

import com.licel.jcardsim.bouncycastle.asn1.ASN1Encodable;
import com.licel.jcardsim.bouncycastle.asn1.ASN1EncodableVector;
import com.licel.jcardsim.bouncycastle.asn1.ASN1Object;
import com.licel.jcardsim.bouncycastle.asn1.ASN1OutputStream;
import com.licel.jcardsim.bouncycastle.asn1.ASN1ParsingException;
import com.licel.jcardsim.bouncycastle.asn1.ASN1Private;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DLPrivate
extends ASN1Private {
    DLPrivate(boolean isConstructed, int tag, byte[] octets) {
        super(isConstructed, tag, octets);
    }

    public DLPrivate(int tag, byte[] octets) {
        this(false, tag, octets);
    }

    public DLPrivate(int tag, ASN1Encodable object) throws IOException {
        this(true, tag, object);
    }

    public DLPrivate(boolean constructed, int tag, ASN1Encodable object) throws IOException {
        super(constructed || object.toASN1Primitive().isConstructed(), tag, DLPrivate.getEncoding(constructed, object));
    }

    private static byte[] getEncoding(boolean explicit, ASN1Encodable object) throws IOException {
        byte[] data = object.toASN1Primitive().getEncoded("DL");
        if (explicit) {
            return data;
        }
        int lenBytes = DLPrivate.getLengthOfHeader(data);
        byte[] tmp = new byte[data.length - lenBytes];
        System.arraycopy(data, lenBytes, tmp, 0, tmp.length);
        return tmp;
    }

    public DLPrivate(int tagNo, ASN1EncodableVector vec) {
        super(true, tagNo, DLPrivate.getEncodedVector(vec));
    }

    private static byte[] getEncodedVector(ASN1EncodableVector vec) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        for (int i = 0; i != vec.size(); ++i) {
            try {
                bOut.write(((ASN1Object)vec.get(i)).getEncoded("DL"));
                continue;
            }
            catch (IOException e) {
                throw new ASN1ParsingException("malformed object: " + e, e);
            }
        }
        return bOut.toByteArray();
    }

    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        int flags = 192;
        if (this.isConstructed) {
            flags |= 0x20;
        }
        out.writeEncoded(withTag, flags, this.tag, this.octets);
    }
}

