/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.asn1;

import com.licel.jcardsim.bouncycastle.asn1.ASN1OctetString;
import com.licel.jcardsim.bouncycastle.asn1.ASN1OutputStream;
import com.licel.jcardsim.bouncycastle.asn1.ASN1Primitive;
import com.licel.jcardsim.bouncycastle.asn1.ASN1String;
import com.licel.jcardsim.bouncycastle.asn1.ASN1TaggedObject;
import com.licel.jcardsim.bouncycastle.asn1.StreamUtil;
import com.licel.jcardsim.bouncycastle.util.Arrays;
import com.licel.jcardsim.bouncycastle.util.Strings;
import java.io.IOException;

public class DERVideotexString
extends ASN1Primitive
implements ASN1String {
    private final byte[] string;

    public static DERVideotexString getInstance(Object obj) {
        if (obj == null || obj instanceof DERVideotexString) {
            return (DERVideotexString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERVideotexString)DERVideotexString.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERVideotexString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DERVideotexString) {
            return DERVideotexString.getInstance(o);
        }
        return new DERVideotexString(ASN1OctetString.getInstance(o).getOctets());
    }

    public DERVideotexString(byte[] string) {
        this.string = Arrays.clone(string);
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length) + this.string.length;
    }

    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        out.writeEncoded(withTag, 21, this.string);
    }

    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof DERVideotexString)) {
            return false;
        }
        DERVideotexString s = (DERVideotexString)o;
        return Arrays.areEqual(this.string, s.string);
    }

    public String getString() {
        return Strings.fromByteArray(this.string);
    }
}

