/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.asn1;

import com.licel.jcardsim.bouncycastle.asn1.ASN1OutputStream;
import com.licel.jcardsim.bouncycastle.asn1.ASN1ParsingException;
import com.licel.jcardsim.bouncycastle.asn1.ASN1Primitive;
import com.licel.jcardsim.bouncycastle.asn1.ASN1String;
import com.licel.jcardsim.bouncycastle.asn1.DERBitString;
import com.licel.jcardsim.bouncycastle.asn1.DLBitString;
import com.licel.jcardsim.bouncycastle.util.Arrays;
import com.licel.jcardsim.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class ASN1BitString
extends ASN1Primitive
implements ASN1String {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected final byte[] data;
    protected final int padBits;

    protected static int getPadBits(int bitString) {
        int val = 0;
        for (int i = 3; i >= 0; --i) {
            if (i != 0) {
                if (bitString >> i * 8 == 0) continue;
                val = bitString >> i * 8 & 0xFF;
                break;
            }
            if (bitString == 0) continue;
            val = bitString & 0xFF;
            break;
        }
        if (val == 0) {
            return 0;
        }
        int bits = 1;
        while (((val <<= 1) & 0xFF) != 0) {
            ++bits;
        }
        return 8 - bits;
    }

    protected static byte[] getBytes(int bitString) {
        if (bitString == 0) {
            return new byte[0];
        }
        int bytes = 4;
        for (int i = 3; i >= 1 && (bitString & 255 << i * 8) == 0; --i) {
            --bytes;
        }
        byte[] result = new byte[bytes];
        for (int i = 0; i < bytes; ++i) {
            result[i] = (byte)(bitString >> i * 8 & 0xFF);
        }
        return result;
    }

    protected ASN1BitString(byte data, int padBits) {
        if (padBits > 7 || padBits < 0) {
            throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
        }
        this.data = new byte[]{data};
        this.padBits = padBits;
    }

    public ASN1BitString(byte[] data, int padBits) {
        if (data == null) {
            throw new NullPointerException("'data' cannot be null");
        }
        if (data.length == 0 && padBits != 0) {
            throw new IllegalArgumentException("zero length data with non-zero pad bits");
        }
        if (padBits > 7 || padBits < 0) {
            throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
        }
        this.data = Arrays.clone(data);
        this.padBits = padBits;
    }

    public String getString() {
        byte[] string;
        StringBuffer buf = new StringBuffer("#");
        try {
            string = this.getEncoded();
        }
        catch (IOException e) {
            throw new ASN1ParsingException("Internal error encoding BitString: " + e.getMessage(), e);
        }
        for (int i = 0; i != string.length; ++i) {
            buf.append(table[string[i] >>> 4 & 0xF]);
            buf.append(table[string[i] & 0xF]);
        }
        return buf.toString();
    }

    public int intValue() {
        int value = 0;
        int end = Math.min(4, this.data.length - 1);
        for (int i = 0; i < end; ++i) {
            value |= (this.data[i] & 0xFF) << 8 * i;
        }
        if (0 <= end && end < 4) {
            byte der = (byte)(this.data[end] & 255 << this.padBits);
            value |= (der & 0xFF) << 8 * end;
        }
        return value;
    }

    public byte[] getOctets() {
        if (this.padBits != 0) {
            throw new IllegalStateException("attempt to get non-octet aligned data from BIT STRING");
        }
        return Arrays.clone(this.data);
    }

    public byte[] getBytes() {
        if (0 == this.data.length) {
            return this.data;
        }
        byte[] rv = Arrays.clone(this.data);
        int n = this.data.length - 1;
        rv[n] = (byte)(rv[n] & 255 << this.padBits);
        return rv;
    }

    public int getPadBits() {
        return this.padBits;
    }

    public String toString() {
        return this.getString();
    }

    public int hashCode() {
        int end = this.data.length;
        if (--end < 0) {
            return 1;
        }
        byte der = (byte)(this.data[end] & 255 << this.padBits);
        int hc = Arrays.hashCode(this.data, 0, end);
        hc *= 257;
        return (hc ^= der) ^ this.padBits;
    }

    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof ASN1BitString)) {
            return false;
        }
        ASN1BitString other = (ASN1BitString)o;
        if (this.padBits != other.padBits) {
            return false;
        }
        byte[] a = this.data;
        int end = a.length;
        byte[] b = other.data;
        if (end != b.length) {
            return false;
        }
        if (--end < 0) {
            return true;
        }
        for (int i = 0; i < end; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        byte derA = (byte)(a[end] & 255 << this.padBits);
        byte derB = (byte)(b[end] & 255 << this.padBits);
        return derA == derB;
    }

    static ASN1BitString fromInputStream(int length, InputStream stream) throws IOException {
        if (length < 1) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        int padBits = stream.read();
        byte[] data = new byte[length - 1];
        if (data.length != 0) {
            if (Streams.readFully(stream, data) != data.length) {
                throw new EOFException("EOF encountered in middle of BIT STRING");
            }
            if (padBits > 0 && padBits < 8 && data[data.length - 1] != (byte)(data[data.length - 1] & 255 << padBits)) {
                return new DLBitString(data, padBits);
            }
        }
        return new DERBitString(data, padBits);
    }

    public ASN1Primitive getLoadedObject() {
        return this.toASN1Primitive();
    }

    ASN1Primitive toDERObject() {
        return new DERBitString(this.data, this.padBits);
    }

    ASN1Primitive toDLObject() {
        return new DLBitString(this.data, this.padBits);
    }

    abstract void encode(ASN1OutputStream var1, boolean var2) throws IOException;
}

