/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javacard.framework.SystemException;

public class TransientMemory {
    protected final ArrayList<Object> clearOnDeselect = new ArrayList();
    protected final ArrayList<Object> clearOnReset = new ArrayList();

    public boolean[] makeBooleanArray(short length, byte event) {
        boolean[] array = new boolean[length];
        this.storeArray(array, event);
        return array;
    }

    public byte[] makeByteArray(int length, byte event) {
        byte[] array = new byte[length];
        this.storeArray(array, event);
        return array;
    }

    public short[] makeShortArray(short length, byte event) {
        short[] array = new short[length];
        this.storeArray(array, event);
        return array;
    }

    public Object[] makeObjectArray(short length, byte event) {
        Object[] array = new Object[length];
        this.storeArray(array, event);
        return array;
    }

    public byte isTransient(Object theObj) {
        if (this.clearOnDeselect.contains(theObj)) {
            return 2;
        }
        if (this.clearOnReset.contains(theObj)) {
            return 1;
        }
        return 0;
    }

    protected void storeArray(Object arrayRef, byte event) {
        switch (event) {
            case 2: {
                this.clearOnDeselect.add(arrayRef);
                break;
            }
            case 1: {
                this.clearOnReset.add(arrayRef);
                break;
            }
            default: {
                SystemException.throwIt((short)1);
            }
        }
    }

    protected void clearOnDeselect() {
        this.zero(this.clearOnDeselect);
    }

    protected void clearOnReset() {
        this.zero(this.clearOnDeselect);
        this.zero(this.clearOnReset);
    }

    protected void forgetBuffers() {
        this.clearOnReset();
        this.clearOnDeselect.clear();
        this.clearOnReset.clear();
    }

    protected void zero(List<Object> list) {
        for (Object obj : list) {
            if (obj instanceof byte[]) {
                Arrays.fill((byte[])obj, (byte)0);
                continue;
            }
            if (obj instanceof short[]) {
                Arrays.fill((short[])obj, (short)0);
                continue;
            }
            if (obj instanceof Object[]) {
                Arrays.fill((Object[])obj, null);
                continue;
            }
            if (!(obj instanceof boolean[])) continue;
            boolean[] array = (boolean[])obj;
            for (int i = 0; i < array.length; ++i) {
                array[i] = false;
            }
        }
    }
}

