/*
 * Decompiled with CFR 0.152.
 */
package javacard.security;

import com.licel.jcardsim.crypto.RandomDataImpl;
import javacard.security.CryptoException;

public abstract class RandomData {
    public static final byte ALG_PSEUDO_RANDOM = 1;
    public static final byte ALG_SECURE_RANDOM = 2;
    public static final byte ALG_TRNG = 3;
    public static final byte ALG_PRESEEDED_DRBG = 4;
    public static final byte ALG_FAST = 5;
    public static final byte ALG_KEYGENERATION = 6;

    protected RandomData() {
    }

    public abstract void generateData(byte[] var1, short var2, short var3) throws CryptoException;

    public abstract short nextBytes(byte[] var1, short var2, short var3) throws CryptoException;

    public abstract void setSeed(byte[] var1, short var2, short var3);

    public abstract byte getAlgorithm();

    public static final RandomData getInstance(byte algorithm) throws CryptoException {
        RandomDataImpl instance = null;
        switch (algorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                instance = new RandomDataImpl(algorithm);
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        return instance;
    }

    public static final class OneShot
    extends RandomData {
        private OneShot() {
        }

        public static final OneShot open(byte by) throws CryptoException {
            return null;
        }

        public void close() {
        }

        @Override
        public byte getAlgorithm() {
            return 0;
        }

        @Override
        public void generateData(byte[] byArray, short s, short s2) throws CryptoException {
        }

        @Override
        public short nextBytes(byte[] byArray, short s, short s2) throws CryptoException {
            return 0;
        }

        @Override
        public void setSeed(byte[] byArray, short s, short s2) {
        }
    }
}

