/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import com.licel.jcardsim.base.ApduCase;
import com.licel.jcardsim.base.SimulatorSystem;
import com.licel.jcardsim.utils.ByteUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import javacard.framework.APDUException;
import javacard.framework.Util;

public final class APDU {
    public static final byte STATE_INITIAL = 0;
    public static final byte STATE_PARTIAL_INCOMING = 1;
    public static final byte STATE_FULL_INCOMING = 2;
    public static final byte STATE_OUTGOING = 3;
    public static final byte STATE_OUTGOING_LENGTH_KNOWN = 4;
    public static final byte STATE_PARTIAL_OUTGOING = 5;
    public static final byte STATE_FULL_OUTGOING = 6;
    public static final byte STATE_ERROR_NO_T0_GETRESPONSE = -1;
    public static final byte STATE_ERROR_T1_IFD_ABORT = -2;
    public static final byte STATE_ERROR_IO = -3;
    public static final byte STATE_ERROR_NO_T0_REISSUE = -4;
    public static final byte PROTOCOL_MEDIA_MASK = -16;
    public static final byte PROTOCOL_TYPE_MASK = 15;
    public static final byte PROTOCOL_T0 = 0;
    public static final byte PROTOCOL_T1 = 1;
    public static final byte PROTOCOL_MEDIA_DEFAULT = 0;
    public static final byte PROTOCOL_MEDIA_CONTACTLESS_TYPE_A = -128;
    public static final byte PROTOCOL_MEDIA_CONTACTLESS_TYPE_B = -112;
    public static final byte PROTOCOL_MEDIA_USB = -96;
    public static final byte PROTOCOL_MEDIA_HCI_APDU_GATE = -80;
    public static final byte PROTOCOL_MEDIA_CONTACTLESS_TYPE_F = -80;
    private static final short BUFFER_SIZE = 261;
    private static final int BUFFER_EXTENDED_SIZE = 32777;
    private static final short T0_IBS = 1;
    private static final short T0_OBS = 258;
    private static final short T1_BLOCK_SIZE = 254;
    private static final byte T0_NAD = 0;
    private short[] ramVars;
    private static final byte LE = 0;
    private static final byte LR = 1;
    private static final byte LC = 3;
    private static final byte PRE_READ_LENGTH = 4;
    private static final byte CURRENT_STATE = 5;
    private static final byte LOGICAL_CHN = 6;
    private static final byte ACTIVE_PROTOCOL = 7;
    private static final byte REMAINING_BYTES = 8;
    private static final byte RAM_VARS_LENGTH = 9;
    private boolean[] flags;
    private static final byte OUTGOING_FLAG = 0;
    private static final byte OUTGOING_LEN_SET_FLAG = 1;
    private static final byte NO_CHAINING_FLAG = 2;
    private static final byte INCOMING_FLAG = 3;
    private static final byte NO_GET_RESPONSE_FLAG = 4;
    private static final byte ACCESS_ALLOWED_FLAG = 5;
    private static final byte FLAGS_LENGTH = 6;
    private final byte[] buffer;
    private final boolean extended;

    public boolean isValidCLA() {
        return false;
    }

    APDU(boolean extended) {
        this.extended = extended;
        this.buffer = new byte[extended ? 32777 : 261];
        this.ramVars = new short[9];
        this.flags = new boolean[6];
        this.internalReset((byte)0, ApduCase.Case1, null);
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public static short getInBlockSize() {
        return (APDU.getProtocol() & 1) == 1 ? (short)254 : 1;
    }

    public static short getOutBlockSize() {
        return (APDU.getProtocol() & 1) == 1 ? (short)254 : 258;
    }

    public static byte getProtocol() {
        APDU apdu = SimulatorSystem.instance().getCurrentAPDU();
        return (byte)((short[])APDU.getFieldInternal(apdu, "ramVars"))[7];
    }

    public byte getNAD() {
        return 0;
    }

    public short setOutgoing() throws APDUException {
        if (this.flags[0]) {
            APDUException.throwIt((short)1);
        }
        this.flags[0] = true;
        this.ramVars[5] = 3;
        return this.ramVars[0];
    }

    public short setOutgoingNoChaining() throws APDUException {
        if (this.flags[0]) {
            APDUException.throwIt((short)1);
        }
        this.flags[0] = true;
        this.flags[2] = true;
        this.ramVars[5] = 3;
        return this.ramVars[0];
    }

    public void setOutgoingLength(short len) throws APDUException {
        short max;
        short s = max = this.extended ? (short)Short.MAX_VALUE : 258;
        if (!this.flags[0]) {
            APDUException.throwIt((short)1);
        }
        if (this.flags[1]) {
            APDUException.throwIt((short)1);
        }
        if (len > max || len < 0) {
            APDUException.throwIt((short)3);
        }
        this.flags[1] = true;
        this.ramVars[5] = 4;
        this.ramVars[1] = len;
    }

    public short receiveBytes(short bOff) throws APDUException {
        short pre;
        if (!this.flags[3] || this.flags[0]) {
            APDUException.throwIt((short)1);
        }
        short remainingBytes = this.ramVars[8];
        if (bOff < 0 || remainingBytes >= 1 && bOff + 1 > this.buffer.length) {
            APDUException.throwIt((short)2);
        }
        if ((pre = (short)(this.ramVars[4] & 0xFF)) != 0) {
            this.ramVars[4] = 0;
            this.ramVars[5] = remainingBytes == 0 ? 2 : 1;
            return pre;
        }
        if (remainingBytes != 0) {
            short len = this.getIncomingLength();
            this.ramVars[8] = remainingBytes = (short)(remainingBytes - len);
            this.ramVars[5] = remainingBytes == 0 ? 2 : 1;
            return len;
        }
        this.ramVars[5] = 2;
        return 0;
    }

    public short setIncomingAndReceive() throws APDUException {
        if (this.ramVars[4] == 0) {
            if (this.flags[3] || this.flags[0]) {
                APDUException.throwIt((short)1);
            }
            this.flags[3] = true;
        }
        return this.receiveBytes(this.getOffsetCdata());
    }

    public void sendBytes(short bOff, short len) throws APDUException {
        short max;
        short s = max = this.extended ? (short)Short.MAX_VALUE : 258;
        if (bOff < 0 || len < 0 || (short)(bOff + len) > max) {
            APDUException.throwIt((short)2);
        }
        if (!this.flags[1] || this.flags[4]) {
            APDUException.throwIt((short)1);
        }
        if (len == 0) {
            return;
        }
        short Lr = this.ramVars[1];
        if (len > Lr) {
            APDUException.throwIt((short)1);
        }
        SimulatorSystem.instance().sendAPDU(this.buffer, bOff, len);
        Lr = (short)(Lr - len);
        this.ramVars[5] = Lr == 0 ? 6 : 5;
        this.ramVars[1] = Lr;
    }

    public void sendBytesLong(byte[] outData, short bOff, short len) throws APDUException, SecurityException {
        int sendLength = this.buffer.length;
        while (len > 0) {
            if (len < sendLength) {
                sendLength = len;
            }
            Util.arrayCopy(outData, bOff, this.buffer, (short)0, (short)sendLength);
            this.sendBytes((short)0, (short)sendLength);
            len = (short)(len - sendLength);
            bOff = (short)(bOff + sendLength);
        }
    }

    public void setOutgoingAndSend(short bOff, short len) throws APDUException {
        this.setOutgoing();
        this.setOutgoingLength(len);
        this.sendBytes(bOff, len);
    }

    public byte getCurrentState() {
        return (byte)this.ramVars[5];
    }

    public static APDU getCurrentAPDU() throws SecurityException {
        APDU currentAPDU = SimulatorSystem.instance().getCurrentAPDU();
        if (!((boolean[])APDU.getFieldInternal(currentAPDU, "flags"))[5]) {
            throw new SecurityException("getCurrentAPDU must not be called outside of Applet#process()");
        }
        return currentAPDU;
    }

    public static byte[] getCurrentAPDUBuffer() throws SecurityException {
        return APDU.getCurrentAPDU().getBuffer();
    }

    public static byte getCLAChannel() {
        APDU apdu = SimulatorSystem.instance().getCurrentAPDU();
        return (byte)((short[])APDU.getFieldInternal(apdu, "ramVars"))[6];
    }

    public static void waitExtension() throws APDUException {
        APDU apdu = SimulatorSystem.instance().getCurrentAPDU();
        boolean[] apduFlags = (boolean[])APDU.getFieldInternal(apdu, "flags");
        if (!apduFlags[5] || apduFlags[2]) {
            APDUException.throwIt((short)1);
        }
    }

    public boolean isCommandChainingCLA() {
        return (this.buffer[0] & 0x10) == 16;
    }

    public boolean isSecureMessagingCLA() {
        return (this.buffer[0] & 0x40) == 64 ? (this.buffer[0] & 0x20) == 32 : (this.buffer[0] & 0xC) != 0;
    }

    public boolean isISOInterindustryCLA() {
        return (this.buffer[0] & 0x80) != 128;
    }

    public short getIncomingLength() {
        if (!this.flags[3] || this.flags[0]) {
            throw new APDUException(1);
        }
        return this.ramVars[3];
    }

    public short getOffsetCdata() {
        if (!this.flags[3] || this.flags[0]) {
            throw new APDUException(1);
        }
        return this.internalGetOffsetCdata();
    }

    private short internalGetOffsetCdata() {
        if (this.extended) {
            return 7;
        }
        return 5;
    }

    private void internalReset(byte protocol, ApduCase apduCase, byte[] inputBuffer) {
        int le;
        short lc;
        if (inputBuffer == null) {
            this.flags[5] = false;
            this.ramVars[7] = protocol;
            return;
        }
        Arrays.fill(this.buffer, (byte)0);
        Arrays.fill(this.ramVars, (short)0);
        System.arraycopy(inputBuffer, 0, this.buffer, 0, inputBuffer.length);
        for (int i = 0; i < this.flags.length; i = (int)((byte)(i + 1))) {
            this.flags[i] = false;
        }
        this.flags[5] = true;
        this.ramVars[7] = protocol;
        switch (apduCase) {
            case Case2: {
                lc = 0;
                byte leByte = this.buffer[4];
                le = (short)(leByte == 0 ? 256 : (short)(0xFF & leByte));
                break;
            }
            case Case2Extended: {
                lc = 0;
                le = ByteUtil.getShort(this.buffer, 5);
                break;
            }
            case Case3: {
                lc = (short)(0xFF & this.buffer[4]);
                le = 0;
                break;
            }
            case Case3Extended: {
                lc = ByteUtil.getShort(this.buffer, 5);
                le = 0;
                break;
            }
            case Case4: {
                lc = (short)(0xFF & this.buffer[4]);
                byte leByte = this.buffer[5 + lc];
                le = (short)(leByte == 0 ? 256 : (short)(0xFF & leByte));
                break;
            }
            case Case4Extended: {
                lc = ByteUtil.getShort(this.buffer, 5);
                le = ByteUtil.getShort(this.buffer, 7 + lc);
                break;
            }
            default: {
                lc = 0;
                le = 0;
            }
        }
        this.ramVars[3] = this.ramVars[8] = lc;
        this.ramVars[0] = le;
    }

    private static Object getFieldInternal(APDU apdu, String fieldName) {
        try {
            Field f = APDU.class.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.get(apdu);
        }
        catch (Exception e) {
            throw new RuntimeException("Internal reflection error", e);
        }
    }
}

