/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.bouncycastle.crypto.BlockCipher;
import com.licel.jcardsim.bouncycastle.crypto.CipherParameters;
import com.licel.jcardsim.bouncycastle.crypto.KeyGenerationParameters;
import com.licel.jcardsim.bouncycastle.crypto.engines.AESEngine;
import com.licel.jcardsim.bouncycastle.crypto.engines.DESEngine;
import com.licel.jcardsim.bouncycastle.crypto.engines.DESedeEngine;
import com.licel.jcardsim.bouncycastle.crypto.params.KeyParameter;
import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.KeyImpl;
import java.security.SecureRandom;
import javacard.security.AESKey;
import javacard.security.CryptoException;
import javacard.security.DESKey;
import javacard.security.HMACKey;

public class SymmetricKeyImpl
extends KeyImpl
implements DESKey,
AESKey,
HMACKey {
    protected ByteContainer key;

    public SymmetricKeyImpl(byte keyType, short keySize) {
        this.size = keySize;
        this.type = keyType;
        switch (keyType) {
            case 2: 
            case 14: 
            case 20: {
                this.key = new ByteContainer(2);
                break;
            }
            case 1: 
            case 13: 
            case 19: {
                this.key = new ByteContainer(1);
                break;
            }
            case 3: 
            case 15: 
            case 21: {
                this.key = new ByteContainer(0);
            }
        }
    }

    @Override
    public void clearKey() {
        this.key.clear();
    }

    @Override
    public void setKey(byte[] keyData, short kOff) throws CryptoException, NullPointerException, ArrayIndexOutOfBoundsException {
        this.key.setBytes(keyData, kOff, (short)(this.size / 8));
    }

    @Override
    public void setKey(byte[] keyData, short kOff, short kLen) throws CryptoException, NullPointerException, ArrayIndexOutOfBoundsException {
        this.key.setBytes(keyData, kOff, kLen);
    }

    @Override
    public byte getKey(byte[] keyData, short kOff) {
        return (byte)this.key.getBytes(keyData, kOff);
    }

    @Override
    public void setParameters(CipherParameters params) {
        this.key.setBytes(((KeyParameter)params).getKey());
    }

    @Override
    public CipherParameters getParameters() throws CryptoException {
        if (!this.key.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        return new KeyParameter(this.key.getBytes((byte)1));
    }

    public BlockCipher getCipher() throws CryptoException {
        if (!this.key.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        BlockCipher cipher = null;
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: {
                if (this.size == 64) {
                    cipher = new DESEngine();
                }
                if (this.size != 128 && this.size != 192) break;
                cipher = new DESedeEngine();
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                cipher = new AESEngine();
            }
        }
        return cipher;
    }

    @Override
    public boolean isInitialized() {
        return this.key.isInitialized();
    }

    @Override
    public KeyGenerationParameters getKeyGenerationParameters(SecureRandom rnd) {
        return null;
    }
}

