/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.bouncycastle.crypto.digests.SHA1Digest;
import com.licel.jcardsim.bouncycastle.crypto.prng.DigestRandomGenerator;
import com.licel.jcardsim.bouncycastle.crypto.prng.RandomGenerator;
import com.licel.jcardsim.bouncycastle.util.encoders.Hex;
import java.security.SecureRandom;
import javacard.framework.Util;
import javacard.security.CryptoException;
import javacard.security.RandomData;

public class RandomDataImpl
extends RandomData {
    byte algorithm;
    RandomGenerator engine;

    public RandomDataImpl(byte algorithm) {
        this.algorithm = algorithm;
        this.engine = new DigestRandomGenerator(new SHA1Digest());
        String randomSeed = System.getProperty("com.licel.jcardsim.randomdata.seed");
        String doSecureRandom = System.getProperty("com.licel.jcardsim.randomdata.secure", "0");
        if (randomSeed != null) {
            this.engine.addSeedMaterial(Hex.decode(randomSeed));
        } else if ("1".equals(doSecureRandom)) {
            byte[] seed = new byte[32];
            SecureRandom randomGenerator = new SecureRandom();
            randomGenerator.nextBytes(seed);
            this.engine.addSeedMaterial(seed);
        }
    }

    @Override
    public void generateData(byte[] buffer, short offset, short length) throws CryptoException {
        this.engine.nextBytes(buffer, offset, length);
    }

    @Override
    public void setSeed(byte[] buffer, short offset, short length) {
        byte[] seed = new byte[length];
        Util.arrayCopyNonAtomic(buffer, offset, seed, (short)0, length);
        this.engine.addSeedMaterial(seed);
    }

    @Override
    public byte getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public short nextBytes(byte[] buffer, short offset, short length) throws CryptoException {
        this.engine.nextBytes(buffer, offset, length);
        return (short)(offset + length);
    }
}

