/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.bouncycastle.crypto.CipherParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.ECDomainParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.ECKeyImpl;
import javacard.security.CryptoException;
import javacard.security.ECPublicKey;

public class ECPublicKeyImpl
extends ECKeyImpl
implements ECPublicKey {
    protected ByteContainer w = new ByteContainer();

    public ECPublicKeyImpl(byte keyType, short keySize) {
        super(keyType, keySize);
    }

    public ECPublicKeyImpl(ECPublicKeyParameters params) {
        super(params);
        this.setParameters(params);
    }

    @Override
    public void setParameters(CipherParameters params) {
        this.w.setBytes(((ECPublicKeyParameters)params).getQ().getEncoded(false));
    }

    @Override
    public void setW(byte[] buffer, short offset, short length) throws CryptoException {
        this.w.setBytes(buffer, offset, length);
    }

    @Override
    public short getW(byte[] buffer, short offset) throws CryptoException {
        return this.w.getBytes(buffer, offset);
    }

    @Override
    public boolean isInitialized() {
        return this.isDomainParametersInitialized() && this.w.isInitialized();
    }

    @Override
    public void clearKey() {
        super.clearKey();
        this.w.clear();
    }

    @Override
    public CipherParameters getParameters() {
        if (!this.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        ECDomainParameters dp = this.getDomainParameters();
        return new ECPublicKeyParameters(dp.getCurve().decodePoint(this.w.getBytes((byte)1)), dp);
    }
}

