/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.pqc.jcajce.provider.sphincs;

import com.licel.jcardsim.bouncycastle.asn1.ASN1Encodable;
import com.licel.jcardsim.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.licel.jcardsim.bouncycastle.asn1.ASN1Set;
import com.licel.jcardsim.bouncycastle.asn1.DEROctetString;
import com.licel.jcardsim.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.licel.jcardsim.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.licel.jcardsim.bouncycastle.crypto.CipherParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.licel.jcardsim.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.licel.jcardsim.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.licel.jcardsim.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.licel.jcardsim.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.licel.jcardsim.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.licel.jcardsim.bouncycastle.pqc.jcajce.interfaces.SPHINCSKey;
import com.licel.jcardsim.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCSphincs256PrivateKey
implements PrivateKey,
SPHINCSKey {
    private static final long serialVersionUID = 1L;
    private transient ASN1ObjectIdentifier treeDigest;
    private transient SPHINCSPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCSphincs256PrivateKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, SPHINCSPrivateKeyParameters sPHINCSPrivateKeyParameters) {
        this.treeDigest = aSN1ObjectIdentifier;
        this.params = sPHINCSPrivateKeyParameters;
    }

    public BCSphincs256PrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.treeDigest = SPHINCS256KeyParams.getInstance((Object)privateKeyInfo.getPrivateKeyAlgorithm().getParameters()).getTreeDigest().getAlgorithm();
        this.params = (SPHINCSPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSphincs256PrivateKey) {
            BCSphincs256PrivateKey bCSphincs256PrivateKey = (BCSphincs256PrivateKey)object;
            return this.treeDigest.equals(bCSphincs256PrivateKey.treeDigest) && Arrays.areEqual(this.params.getKeyData(), bCSphincs256PrivateKey.params.getKeyData());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode(this.params.getKeyData());
    }

    @Override
    public final String getAlgorithm() {
        return "SPHINCS-256";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo;
            if (this.params.getTreeDigest() != null) {
                privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)this.params, (ASN1Set)this.attributes);
            } else {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, (ASN1Encodable)new SPHINCS256KeyParams(new AlgorithmIdentifier(this.treeDigest)));
                privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(this.params.getKeyData()), this.attributes);
            }
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    ASN1ObjectIdentifier getTreeDigest() {
        return this.treeDigest;
    }

    public byte[] getKeyData() {
        return this.params.getKeyData();
    }

    CipherParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance((Object)byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

