/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.pqc.jcajce.provider.qtesla;

import com.licel.jcardsim.bouncycastle.asn1.ASN1Set;
import com.licel.jcardsim.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.licel.jcardsim.bouncycastle.crypto.CipherParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.licel.jcardsim.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import com.licel.jcardsim.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import com.licel.jcardsim.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.licel.jcardsim.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.licel.jcardsim.bouncycastle.pqc.jcajce.interfaces.QTESLAKey;
import com.licel.jcardsim.bouncycastle.pqc.jcajce.spec.QTESLAParameterSpec;
import com.licel.jcardsim.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCqTESLAPrivateKey
implements PrivateKey,
QTESLAKey {
    private static final long serialVersionUID = 1L;
    private transient QTESLAPrivateKeyParameters keyParams;
    private transient ASN1Set attributes;

    public BCqTESLAPrivateKey(QTESLAPrivateKeyParameters qTESLAPrivateKeyParameters) {
        this.keyParams = qTESLAPrivateKeyParameters;
    }

    public BCqTESLAPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.keyParams = (QTESLAPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)privateKeyInfo);
    }

    @Override
    public final String getAlgorithm() {
        return QTESLASecurityCategory.getName((int)this.keyParams.getSecurityCategory());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    public QTESLAParameterSpec getParams() {
        return new QTESLAParameterSpec(this.getAlgorithm());
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)this.keyParams, (ASN1Set)this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCqTESLAPrivateKey) {
            BCqTESLAPrivateKey bCqTESLAPrivateKey = (BCqTESLAPrivateKey)object;
            return this.keyParams.getSecurityCategory() == bCqTESLAPrivateKey.keyParams.getSecurityCategory() && Arrays.areEqual(this.keyParams.getSecret(), bCqTESLAPrivateKey.keyParams.getSecret());
        }
        return false;
    }

    public int hashCode() {
        return this.keyParams.getSecurityCategory() + 37 * Arrays.hashCode(this.keyParams.getSecret());
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance((Object)byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

