/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.pqc.crypto.lms;

import com.licel.jcardsim.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.licel.jcardsim.bouncycastle.crypto.Digest;
import com.licel.jcardsim.bouncycastle.pqc.crypto.lms.DigestUtil;
import com.licel.jcardsim.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import com.licel.jcardsim.bouncycastle.pqc.crypto.lms.LMSContext;
import com.licel.jcardsim.bouncycastle.pqc.crypto.lms.LMSigParameters;
import com.licel.jcardsim.bouncycastle.pqc.crypto.lms.LmsUtils;
import com.licel.jcardsim.bouncycastle.pqc.crypto.lms.SeedDerive;

class LMOtsPrivateKey {
    private final LMOtsParameters parameter;
    private final byte[] I;
    private final int q;
    private final byte[] masterSecret;

    public LMOtsPrivateKey(LMOtsParameters lMOtsParameters, byte[] byArray, int n, byte[] byArray2) {
        this.parameter = lMOtsParameters;
        this.I = byArray;
        this.q = n;
        this.masterSecret = byArray2;
    }

    LMSContext getSignatureContext(LMSigParameters lMSigParameters, byte[][] byArray) {
        byte[] byArray2 = new byte[32];
        SeedDerive seedDerive = this.getDerivationFunction();
        seedDerive.setJ(-3);
        seedDerive.deriveSeed(byArray2, false);
        Digest digest = DigestUtil.getDigest((ASN1ObjectIdentifier)this.parameter.getDigestOID());
        LmsUtils.byteArray((byte[])this.getI(), (Digest)digest);
        LmsUtils.u32str((int)this.getQ(), (Digest)digest);
        LmsUtils.u16str((short)-32383, (Digest)digest);
        LmsUtils.byteArray((byte[])byArray2, (Digest)digest);
        return new LMSContext(this, lMSigParameters, digest, byArray2, byArray);
    }

    SeedDerive getDerivationFunction() {
        SeedDerive seedDerive = new SeedDerive(this.I, this.masterSecret, DigestUtil.getDigest((ASN1ObjectIdentifier)this.parameter.getDigestOID()));
        seedDerive.setQ(this.q);
        return seedDerive;
    }

    public LMOtsParameters getParameter() {
        return this.parameter;
    }

    public byte[] getI() {
        return this.I;
    }

    public int getQ() {
        return this.q;
    }

    public byte[] getMasterSecret() {
        return this.masterSecret;
    }
}

