/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.math.ec.custom.sec;

import com.licel.jcardsim.bouncycastle.math.ec.ECFieldElement;
import com.licel.jcardsim.bouncycastle.math.ec.custom.sec.SecT283Field;
import com.licel.jcardsim.bouncycastle.math.raw.Nat;
import com.licel.jcardsim.bouncycastle.math.raw.Nat320;
import com.licel.jcardsim.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecT283FieldElement
extends ECFieldElement.AbstractF2m {
    protected long[] x;

    public SecT283FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.bitLength() > 283) {
            throw new IllegalArgumentException("x value invalid for SecT283FieldElement");
        }
        this.x = SecT283Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SecT283FieldElement() {
        this.x = Nat320.create64();
    }

    protected SecT283FieldElement(long[] lArray) {
        this.x = lArray;
    }

    @Override
    public boolean isOne() {
        return Nat320.isOne64((long[])this.x);
    }

    @Override
    public boolean isZero() {
        return Nat320.isZero64((long[])this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat320.toBigInteger64((long[])this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT283Field";
    }

    @Override
    public int getFieldSize() {
        return 283;
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        long[] lArray = Nat320.create64();
        SecT283Field.add((long[])this.x, (long[])((SecT283FieldElement)eCFieldElement).x, (long[])lArray);
        return new SecT283FieldElement(lArray);
    }

    @Override
    public ECFieldElement addOne() {
        long[] lArray = Nat320.create64();
        SecT283Field.addOne((long[])this.x, (long[])lArray);
        return new SecT283FieldElement(lArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        return this.add(eCFieldElement);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        long[] lArray = Nat320.create64();
        SecT283Field.multiply((long[])this.x, (long[])((SecT283FieldElement)eCFieldElement).x, (long[])lArray);
        return new SecT283FieldElement(lArray);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiplyPlusProduct(eCFieldElement, eCFieldElement2, eCFieldElement3);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT283FieldElement)eCFieldElement).x;
        long[] lArray3 = ((SecT283FieldElement)eCFieldElement2).x;
        long[] lArray4 = ((SecT283FieldElement)eCFieldElement3).x;
        long[] lArray5 = Nat.create64(9);
        SecT283Field.multiplyAddToExt((long[])lArray, (long[])lArray2, (long[])lArray5);
        SecT283Field.multiplyAddToExt((long[])lArray3, (long[])lArray4, (long[])lArray5);
        long[] lArray6 = Nat320.create64();
        SecT283Field.reduce((long[])lArray5, (long[])lArray6);
        return new SecT283FieldElement(lArray6);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        return this.multiply(eCFieldElement.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        long[] lArray = Nat320.create64();
        SecT283Field.square((long[])this.x, (long[])lArray);
        return new SecT283FieldElement(lArray);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.squarePlusProduct(eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT283FieldElement)eCFieldElement).x;
        long[] lArray3 = ((SecT283FieldElement)eCFieldElement2).x;
        long[] lArray4 = Nat.create64(9);
        SecT283Field.squareAddToExt((long[])lArray, (long[])lArray4);
        SecT283Field.multiplyAddToExt((long[])lArray2, (long[])lArray3, (long[])lArray4);
        long[] lArray5 = Nat320.create64();
        SecT283Field.reduce((long[])lArray4, (long[])lArray5);
        return new SecT283FieldElement(lArray5);
    }

    @Override
    public ECFieldElement squarePow(int n) {
        if (n < 1) {
            return this;
        }
        long[] lArray = Nat320.create64();
        SecT283Field.squareN((long[])this.x, (int)n, (long[])lArray);
        return new SecT283FieldElement(lArray);
    }

    @Override
    public ECFieldElement halfTrace() {
        long[] lArray = Nat320.create64();
        SecT283Field.halfTrace((long[])this.x, (long[])lArray);
        return new SecT283FieldElement(lArray);
    }

    @Override
    public boolean hasFastTrace() {
        return true;
    }

    @Override
    public int trace() {
        return SecT283Field.trace((long[])this.x);
    }

    @Override
    public ECFieldElement invert() {
        long[] lArray = Nat320.create64();
        SecT283Field.invert((long[])this.x, (long[])lArray);
        return new SecT283FieldElement(lArray);
    }

    @Override
    public ECFieldElement sqrt() {
        long[] lArray = Nat320.create64();
        SecT283Field.sqrt((long[])this.x, (long[])lArray);
        return new SecT283FieldElement(lArray);
    }

    public int getRepresentation() {
        return 3;
    }

    public int getM() {
        return 283;
    }

    public int getK1() {
        return 5;
    }

    public int getK2() {
        return 7;
    }

    public int getK3() {
        return 12;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecT283FieldElement)) {
            return false;
        }
        SecT283FieldElement secT283FieldElement = (SecT283FieldElement)object;
        return Nat320.eq64((long[])this.x, (long[])secT283FieldElement.x);
    }

    public int hashCode() {
        return 0x2B33AB ^ Arrays.hashCode(this.x, 0, 5);
    }
}

