/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.math.ec.custom.sec;

import com.licel.jcardsim.bouncycastle.math.ec.ECFieldElement;
import com.licel.jcardsim.bouncycastle.math.ec.custom.sec.SecP160R2Field;
import com.licel.jcardsim.bouncycastle.math.raw.Nat160;
import com.licel.jcardsim.bouncycastle.util.Arrays;
import com.licel.jcardsim.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP160R2FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFAC73"));
    protected int[] x;

    public SecP160R2FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP160R2FieldElement");
        }
        this.x = SecP160R2Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SecP160R2FieldElement() {
        this.x = Nat160.create();
    }

    protected SecP160R2FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat160.isZero((int[])this.x);
    }

    @Override
    public boolean isOne() {
        return Nat160.isOne((int[])this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat160.getBit((int[])this.x, (int)0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat160.toBigInteger((int[])this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP160R2Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat160.create();
        SecP160R2Field.add((int[])this.x, (int[])((SecP160R2FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP160R2FieldElement(nArray);
    }

    @Override
    public ECFieldElement addOne() {
        int[] nArray = Nat160.create();
        SecP160R2Field.addOne((int[])this.x, (int[])nArray);
        return new SecP160R2FieldElement(nArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat160.create();
        SecP160R2Field.subtract((int[])this.x, (int[])((SecP160R2FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP160R2FieldElement(nArray);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat160.create();
        SecP160R2Field.multiply((int[])this.x, (int[])((SecP160R2FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP160R2FieldElement(nArray);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat160.create();
        SecP160R2Field.inv((int[])((SecP160R2FieldElement)eCFieldElement).x, (int[])nArray);
        SecP160R2Field.multiply((int[])nArray, (int[])this.x, (int[])nArray);
        return new SecP160R2FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        int[] nArray = Nat160.create();
        SecP160R2Field.negate((int[])this.x, (int[])nArray);
        return new SecP160R2FieldElement(nArray);
    }

    @Override
    public ECFieldElement square() {
        int[] nArray = Nat160.create();
        SecP160R2Field.square((int[])this.x, (int[])nArray);
        return new SecP160R2FieldElement(nArray);
    }

    @Override
    public ECFieldElement invert() {
        int[] nArray = Nat160.create();
        SecP160R2Field.inv((int[])this.x, (int[])nArray);
        return new SecP160R2FieldElement(nArray);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat160.isZero((int[])nArray) || Nat160.isOne((int[])nArray)) {
            return this;
        }
        int[] nArray2 = Nat160.create();
        SecP160R2Field.square((int[])nArray, (int[])nArray2);
        SecP160R2Field.multiply((int[])nArray2, (int[])nArray, (int[])nArray2);
        int[] nArray3 = Nat160.create();
        SecP160R2Field.square((int[])nArray2, (int[])nArray3);
        SecP160R2Field.multiply((int[])nArray3, (int[])nArray, (int[])nArray3);
        int[] nArray4 = Nat160.create();
        SecP160R2Field.square((int[])nArray3, (int[])nArray4);
        SecP160R2Field.multiply((int[])nArray4, (int[])nArray, (int[])nArray4);
        int[] nArray5 = Nat160.create();
        SecP160R2Field.squareN((int[])nArray4, (int)3, (int[])nArray5);
        SecP160R2Field.multiply((int[])nArray5, (int[])nArray3, (int[])nArray5);
        int[] nArray6 = nArray4;
        SecP160R2Field.squareN((int[])nArray5, (int)7, (int[])nArray6);
        SecP160R2Field.multiply((int[])nArray6, (int[])nArray5, (int[])nArray6);
        int[] nArray7 = nArray5;
        SecP160R2Field.squareN((int[])nArray6, (int)3, (int[])nArray7);
        SecP160R2Field.multiply((int[])nArray7, (int[])nArray3, (int[])nArray7);
        int[] nArray8 = Nat160.create();
        SecP160R2Field.squareN((int[])nArray7, (int)14, (int[])nArray8);
        SecP160R2Field.multiply((int[])nArray8, (int[])nArray6, (int[])nArray8);
        int[] nArray9 = nArray6;
        SecP160R2Field.squareN((int[])nArray8, (int)31, (int[])nArray9);
        SecP160R2Field.multiply((int[])nArray9, (int[])nArray8, (int[])nArray9);
        int[] nArray10 = nArray8;
        SecP160R2Field.squareN((int[])nArray9, (int)62, (int[])nArray10);
        SecP160R2Field.multiply((int[])nArray10, (int[])nArray9, (int[])nArray10);
        int[] nArray11 = nArray9;
        SecP160R2Field.squareN((int[])nArray10, (int)3, (int[])nArray11);
        SecP160R2Field.multiply((int[])nArray11, (int[])nArray3, (int[])nArray11);
        int[] nArray12 = nArray11;
        SecP160R2Field.squareN((int[])nArray12, (int)18, (int[])nArray12);
        SecP160R2Field.multiply((int[])nArray12, (int[])nArray7, (int[])nArray12);
        SecP160R2Field.squareN((int[])nArray12, (int)2, (int[])nArray12);
        SecP160R2Field.multiply((int[])nArray12, (int[])nArray, (int[])nArray12);
        SecP160R2Field.squareN((int[])nArray12, (int)3, (int[])nArray12);
        SecP160R2Field.multiply((int[])nArray12, (int[])nArray2, (int[])nArray12);
        SecP160R2Field.squareN((int[])nArray12, (int)6, (int[])nArray12);
        SecP160R2Field.multiply((int[])nArray12, (int[])nArray3, (int[])nArray12);
        SecP160R2Field.squareN((int[])nArray12, (int)2, (int[])nArray12);
        SecP160R2Field.multiply((int[])nArray12, (int[])nArray, (int[])nArray12);
        int[] nArray13 = nArray2;
        SecP160R2Field.square((int[])nArray12, (int[])nArray13);
        return Nat160.eq((int[])nArray, (int[])nArray13) ? new SecP160R2FieldElement(nArray12) : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecP160R2FieldElement)) {
            return false;
        }
        SecP160R2FieldElement secP160R2FieldElement = (SecP160R2FieldElement)object;
        return Nat160.eq((int[])this.x, (int[])secP160R2FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 5);
    }
}

