/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.math.ec.custom.djb;

import com.licel.jcardsim.bouncycastle.math.raw.Mod;
import com.licel.jcardsim.bouncycastle.math.raw.Nat;
import com.licel.jcardsim.bouncycastle.math.raw.Nat256;
import com.licel.jcardsim.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

/*
 * Exception performing whole class analysis ignored.
 */
public class Curve25519Field {
    private static final long M = 0xFFFFFFFFL;
    static final int[] P = new int[]{-19, -1, -1, -1, -1, -1, -1, Integer.MAX_VALUE};
    private static final int P7 = Integer.MAX_VALUE;
    private static final int[] PExt = new int[]{361, 0, 0, 0, 0, 0, 0, 0, -19, -1, -1, -1, -1, -1, -1, 0x3FFFFFFF};
    private static final int PInv = 19;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        Nat256.add((int[])nArray, (int[])nArray2, (int[])nArray3);
        if (Nat256.gte((int[])nArray3, (int[])P)) {
            Curve25519Field.subPFrom((int[])nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        Nat.add(16, nArray, nArray2, nArray3);
        if (Nat.gte(16, nArray3, PExt)) {
            Curve25519Field.subPExtFrom((int[])nArray3);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        Nat.inc(8, nArray, nArray2);
        if (Nat256.gte((int[])nArray2, (int[])P)) {
            Curve25519Field.subPFrom((int[])nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger bigInteger) {
        int[] nArray = Nat256.fromBigInteger((BigInteger)bigInteger);
        while (Nat256.gte((int[])nArray, (int[])P)) {
            Nat256.subFrom((int[])P, (int[])nArray);
        }
        return nArray;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(8, nArray, 0, nArray2);
        } else {
            Nat256.add((int[])nArray, (int[])P, (int[])nArray2);
            Nat.shiftDownBit(8, nArray2, 0);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            n |= nArray[i];
        }
        n = n >>> 1 | n & 1;
        return n - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat256.createExt();
        Nat256.mul((int[])nArray, (int[])nArray2, (int[])nArray4);
        Curve25519Field.reduce((int[])nArray4, (int[])nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        Nat256.mulAddTo((int[])nArray, (int[])nArray2, (int[])nArray3);
        if (Nat.gte(16, nArray3, PExt)) {
            Curve25519Field.subPExtFrom((int[])nArray3);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (0 != Curve25519Field.isZero((int[])nArray)) {
            Nat256.sub((int[])P, (int[])P, (int[])nArray2);
        } else {
            Nat256.sub((int[])P, (int[])nArray, (int[])nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        byte[] byArray = new byte[32];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 8);
            nArray[7] = nArray[7] & Integer.MAX_VALUE;
        } while (0 == Nat.lessThan(8, nArray, P));
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            Curve25519Field.random((SecureRandom)secureRandom, (int[])nArray);
        } while (0 != Curve25519Field.isZero((int[])nArray));
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        int n = nArray[7];
        Nat.shiftUpBit(8, nArray, 8, n, nArray2, 0);
        int n2 = Nat256.mulByWordAddTo((int)19, (int[])nArray, (int[])nArray2) << 1;
        int n3 = nArray2[7];
        n2 += (n3 >>> 31) - (n >>> 31);
        n3 &= Integer.MAX_VALUE;
        nArray2[7] = n3 += Nat.addWordTo(7, n2 * 19, nArray2);
        if (Nat256.gte((int[])nArray2, (int[])P)) {
            Curve25519Field.subPFrom((int[])nArray2);
        }
    }

    public static void reduce27(int n, int[] nArray) {
        int n2 = nArray[7];
        int n3 = n << 1 | n2 >>> 31;
        n2 &= Integer.MAX_VALUE;
        nArray[7] = n2 += Nat.addWordTo(7, n3 * 19, nArray);
        if (Nat256.gte((int[])nArray, (int[])P)) {
            Curve25519Field.subPFrom((int[])nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat256.createExt();
        Nat256.square((int[])nArray, (int[])nArray3);
        Curve25519Field.reduce((int[])nArray3, (int[])nArray2);
    }

    public static void squareN(int[] nArray, int n, int[] nArray2) {
        int[] nArray3 = Nat256.createExt();
        Nat256.square((int[])nArray, (int[])nArray3);
        Curve25519Field.reduce((int[])nArray3, (int[])nArray2);
        while (--n > 0) {
            Nat256.square((int[])nArray2, (int[])nArray3);
            Curve25519Field.reduce((int[])nArray3, (int[])nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat256.sub((int[])nArray, (int[])nArray2, (int[])nArray3);
        if (n != 0) {
            Curve25519Field.addPTo((int[])nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat.sub(16, nArray, nArray2, nArray3);
        if (n != 0) {
            Curve25519Field.addPExtTo((int[])nArray3);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        Nat.shiftUpBit(8, nArray, 0, nArray2);
        if (Nat256.gte((int[])nArray2, (int[])P)) {
            Curve25519Field.subPFrom((int[])nArray2);
        }
    }

    private static int addPTo(int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) - 19L;
        nArray[0] = (int)l;
        if ((l >>= 32) != 0L) {
            l = Nat.decAt(7, nArray, 1);
        }
        nArray[7] = (int)(l += ((long)nArray[7] & 0xFFFFFFFFL) + 0x80000000L);
        return (int)(l >>= 32);
    }

    private static int addPExtTo(int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)PExt[0] & 0xFFFFFFFFL);
        nArray[0] = (int)l;
        if ((l >>= 32) != 0L) {
            l = Nat.incAt(8, nArray, 1);
        }
        nArray[8] = (int)(l += ((long)nArray[8] & 0xFFFFFFFFL) - 19L);
        if ((l >>= 32) != 0L) {
            l = Nat.decAt(15, nArray, 9);
        }
        nArray[15] = (int)(l += ((long)nArray[15] & 0xFFFFFFFFL) + ((long)(PExt[15] + 1) & 0xFFFFFFFFL));
        return (int)(l >>= 32);
    }

    private static int subPFrom(int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) + 19L;
        nArray[0] = (int)l;
        if ((l >>= 32) != 0L) {
            l = Nat.incAt(7, nArray, 1);
        }
        nArray[7] = (int)(l += ((long)nArray[7] & 0xFFFFFFFFL) - 0x80000000L);
        return (int)(l >>= 32);
    }

    private static int subPExtFrom(int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) - ((long)PExt[0] & 0xFFFFFFFFL);
        nArray[0] = (int)l;
        if ((l >>= 32) != 0L) {
            l = Nat.decAt(8, nArray, 1);
        }
        nArray[8] = (int)(l += ((long)nArray[8] & 0xFFFFFFFFL) + 19L);
        if ((l >>= 32) != 0L) {
            l = Nat.incAt(15, nArray, 9);
        }
        nArray[15] = (int)(l += ((long)nArray[15] & 0xFFFFFFFFL) - ((long)(PExt[15] + 1) & 0xFFFFFFFFL));
        return (int)(l >>= 32);
    }
}

