/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.bouncycastle.crypto.generators;

import com.licel.jcardsim.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.licel.jcardsim.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.licel.jcardsim.bouncycastle.crypto.KeyGenerationParameters;
import com.licel.jcardsim.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import com.licel.jcardsim.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DHParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.licel.jcardsim.bouncycastle.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

