/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import com.licel.jcardsim.base.SimulatorRuntime;
import com.licel.jcardsim.base.SimulatorSystem;
import com.licel.jcardsim.bouncycastle.util.encoders.Hex;
import com.licel.jcardsim.io.JavaCardInterface;
import com.licel.jcardsim.utils.AIDUtil;
import com.licel.jcardsim.utils.ByteUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import javacard.framework.AID;
import javacard.framework.Applet;
import javacard.framework.SystemException;

public class Simulator
implements JavaCardInterface {
    public static final String DEFAULT_ATR = "3BFA1800008131FE454A434F5033315632333298";
    public static final String ATR_SYSTEM_PROPERTY = "com.licel.jcardsim.card.ATR";
    static final String PROPERTY_PREFIX = "com.licel.jcardsim.card.applet.";
    static final String OLD_PROPERTY_PREFIX = "com.licel.jcardsim.smartcardio.applet.";
    static final MessageFormat AID_SP_TEMPLATE = new MessageFormat("{0}.AID");
    static final MessageFormat APPLET_CLASS_SP_TEMPLATE = new MessageFormat("{0}.Class");
    final AppletClassLoader cl = new AppletClassLoader(new URL[0]);
    protected final SimulatorRuntime runtime;
    private String protocol = "T=0";

    public Simulator() {
        this(SimulatorSystem.DEFAULT_RUNTIME, System.getProperties());
    }

    public Simulator(SimulatorRuntime runtime) {
        this(runtime, System.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Simulator(SimulatorRuntime runtime, Properties properties) {
        if (runtime == null) {
            throw new NullPointerException("runtime");
        }
        SimulatorRuntime simulatorRuntime = this.runtime = runtime;
        synchronized (simulatorRuntime) {
            this.runtime.resetRuntime();
        }
        this.changeProtocol(this.protocol);
        for (int i = 0; i < 100 && !properties.isEmpty(); ++i) {
            byte[] aidBytes;
            String appletClassName;
            String selectedPrefix = PROPERTY_PREFIX;
            String aidPropertyName = PROPERTY_PREFIX + AID_SP_TEMPLATE.format(new Object[]{i});
            String aidPropertyOldName = OLD_PROPERTY_PREFIX + AID_SP_TEMPLATE.format(new Object[]{i});
            String appletAID = properties.getProperty(aidPropertyName);
            if (appletAID == null && (appletAID = properties.getProperty(aidPropertyOldName)) != null) {
                selectedPrefix = OLD_PROPERTY_PREFIX;
            }
            if (appletAID == null || (appletClassName = properties.getProperty(selectedPrefix + APPLET_CLASS_SP_TEMPLATE.format(new Object[]{i}))) == null || (aidBytes = Hex.decode(appletAID)) == null || aidBytes.length < 5 || aidBytes.length > 16) continue;
            this.loadApplet(new AID(aidBytes, 0, (byte)aidBytes.length), appletClassName);
        }
    }

    @Override
    public AID loadApplet(AID aid, String appletClassName, byte[] appletJarContents) throws SystemException {
        byte[] aidData = new byte[16];
        aid.getBytes(aidData, (short)0);
        Class<? extends Applet> appletClass = null;
        try {
            this.cl.addAppletContents(appletJarContents);
            appletClass = this.requireExtendsApplet(this.cl.loadClass(appletClassName));
        }
        catch (Exception e) {
            SystemException.throwIt((short)1);
        }
        if (appletClass != null) {
            return this.loadApplet(aid, appletClass);
        }
        SystemException.throwIt((short)1);
        return null;
    }

    @Override
    public AID loadApplet(AID aid, String appletClassName) throws SystemException {
        Class<? extends Applet> appletClass = null;
        try {
            appletClass = this.requireExtendsApplet(this.cl.loadClass(appletClassName));
        }
        catch (ClassNotFoundException ex) {
            SystemException.throwIt((short)1);
        }
        return this.loadApplet(aid, appletClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AID loadApplet(AID aid, Class<? extends Applet> appletClass) throws SystemException {
        SimulatorRuntime simulatorRuntime = this.runtime;
        synchronized (simulatorRuntime) {
            this.runtime.loadApplet(aid, this.requireExtendsApplet(appletClass));
        }
        return aid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AID createApplet(AID aid, byte[] bArray, short bOffset, byte bLength) throws SystemException {
        try {
            SimulatorRuntime simulatorRuntime = this.runtime;
            synchronized (simulatorRuntime) {
                this.runtime.installApplet(aid, bArray, bOffset, bLength);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SystemException.throwIt((short)25668);
        }
        return aid;
    }

    public AID installApplet(AID aid, Class<? extends Applet> appletClass) throws SystemException {
        return this.installApplet(aid, appletClass, new byte[0], (short)0, (byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AID installApplet(AID aid, Class<? extends Applet> appletClass, byte[] bArray, short bOffset, byte bLength) throws SystemException {
        SimulatorRuntime simulatorRuntime = this.runtime;
        synchronized (simulatorRuntime) {
            this.loadApplet(aid, appletClass);
            return this.createApplet(aid, bArray, bOffset, bLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AID installApplet(AID aid, String appletClassName, byte[] bArray, short bOffset, byte bLength) throws SystemException {
        SimulatorRuntime simulatorRuntime = this.runtime;
        synchronized (simulatorRuntime) {
            this.loadApplet(aid, appletClassName);
            return this.createApplet(aid, bArray, bOffset, bLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AID installApplet(AID aid, String appletClassName, byte[] appletContents, byte[] bArray, short bOffset, byte bLength) throws SystemException {
        SimulatorRuntime simulatorRuntime = this.runtime;
        synchronized (simulatorRuntime) {
            this.loadApplet(aid, appletClassName, appletContents);
            return this.createApplet(aid, bArray, bOffset, bLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteApplet(AID aid) {
        SimulatorRuntime simulatorRuntime = this.runtime;
        synchronized (simulatorRuntime) {
            this.runtime.deleteApplet(aid);
        }
    }

    @Override
    public boolean selectApplet(AID aid) throws SystemException {
        byte[] resp = this.selectAppletWithResult(aid);
        return ByteUtil.getSW(resp) == -28672;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] selectAppletWithResult(AID aid) throws SystemException {
        SimulatorRuntime simulatorRuntime = this.runtime;
        synchronized (simulatorRuntime) {
            return this.runtime.transmitCommand(AIDUtil.select(aid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transmitCommand(byte[] command) {
        SimulatorRuntime simulatorRuntime = this.runtime;
        synchronized (simulatorRuntime) {
            return this.runtime.transmitCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        SimulatorRuntime simulatorRuntime = this.runtime;
        synchronized (simulatorRuntime) {
            this.runtime.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetRuntime() {
        SimulatorRuntime simulatorRuntime = this.runtime;
        synchronized (simulatorRuntime) {
            this.runtime.resetRuntime();
        }
    }

    @Override
    public byte[] getATR() {
        return Hex.decode(System.getProperty(ATR_SYSTEM_PROPERTY, DEFAULT_ATR));
    }

    protected byte getProtocolByte(String protocol) {
        int protocolByte;
        if (protocol == null) {
            throw new NullPointerException("protocol");
        }
        String p = protocol.toUpperCase(Locale.ENGLISH).replace(" ", "");
        if (p.equals("T=0") || p.equals("*")) {
            protocolByte = 0;
        } else if (p.equals("T=1")) {
            protocolByte = 1;
        } else if (p.equals("T=CL,TYPE_A,T0") || p.equals("T=CL")) {
            protocolByte = -128;
            protocolByte = (byte)(protocolByte | 0);
        } else if (p.equals("T=CL,TYPE_A,T1")) {
            protocolByte = -128;
            protocolByte = (byte)(protocolByte | 1);
        } else if (p.equals("T=CL,TYPE_B,T0")) {
            protocolByte = -112;
            protocolByte = (byte)(protocolByte | 0);
        } else if (p.equals("T=CL,TYPE_B,T1")) {
            protocolByte = -112;
            protocolByte = (byte)(protocolByte | 1);
        } else {
            throw new IllegalArgumentException("Unknown protocol: " + protocol);
        }
        return (byte)protocolByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeProtocol(String protocol) {
        SimulatorRuntime simulatorRuntime = this.runtime;
        synchronized (simulatorRuntime) {
            this.runtime.changeProtocol(this.getProtocolByte(protocol));
            this.protocol = protocol;
        }
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    private Class<? extends Applet> requireExtendsApplet(Class<?> aClass) {
        if (!Applet.class.isAssignableFrom(aClass)) {
            throw new SystemException(1);
        }
        return aClass;
    }

    class AppletClassLoader
    extends URLClassLoader {
        AppletClassLoader(URL[] urls) {
            super(urls, Simulator.class.getClassLoader());
        }

        void addAppletContents(byte[] appletJarContents) throws IOException {
            File downloadedAppletJar = File.createTempFile("applet", "contents");
            downloadedAppletJar.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(downloadedAppletJar);
            fos.write(appletJarContents);
            fos.close();
            this.addURL(downloadedAppletJar.toURI().toURL());
        }
    }
}

