/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import com.licel.jcardsim.base.SimulatorRuntime;
import com.licel.jcardsim.esotericsoftware.kryo.Kryo;
import com.licel.jcardsim.esotericsoftware.kryo.io.Input;
import com.licel.jcardsim.esotericsoftware.kryo.io.Output;
import com.licel.jcardsim.objenesis.strategy.StdInstantiatorStrategy;
import com.licel.jcardsim.utils.AIDUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javacard.framework.AID;
import javacard.framework.Applet;
import javacard.framework.SystemException;

public class PersistentSimulatorRuntime
extends SimulatorRuntime {
    public static final String PERSISTENT_BASE_DIR = "persistentSimulatorRuntime.dir";
    protected final Kryo kryo = new Kryo();
    protected String appletsDir;

    public PersistentSimulatorRuntime() {
        this.kryo.setReferences(true);
        this.kryo.setRegistrationRequired(false);
        this.kryo.setInstantiatorStrategy(new StdInstantiatorStrategy());
        String baseDir = System.getProperties().getProperty(PERSISTENT_BASE_DIR, null);
        if (baseDir != null) {
            Path p = Paths.get(baseDir, System.getProperty("com.licel.jcardsim.card.ATR", "3BFA1800008131FE454A434F5033315632333298"));
            File appletsDirFile = p.toFile();
            if (!appletsDirFile.exists()) {
                try {
                    Files.createDirectories(p, new FileAttribute[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
            this.appletsDir = appletsDirFile.getAbsolutePath();
        }
    }

    @Override
    public void loadApplet(AID aid, Class<? extends Applet> appletClass) {
        File appletInstanceFile;
        super.loadApplet(aid, appletClass);
        if (this.appletsDir != null && (appletInstanceFile = new File(this.appletsDir, AIDUtil.toString(aid))).isFile()) {
            try (Input input = new Input(new FileInputStream(appletInstanceFile));){
                Applet object = (Applet)this.kryo.readClassAndObject(input);
                this.applets.put(aid, new SimulatorRuntime.ApplicationInstance(aid, object));
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public void installApplet(AID loadFileAID, AID moduleAID, AID appletAID, byte[] bArray, short bOffset, byte bLength) {
        super.installApplet(loadFileAID, moduleAID, appletAID, bArray, bOffset, bLength);
        if (this.appletsDir != null) {
            try {
                AID varianceAid = appletAID;
                File appletInstanceFile = new File(this.appletsDir, AIDUtil.toString(varianceAid));
                Applet applet = this.lookupApplet(varianceAid).getApplet();
                try (Output output = new Output(new FileOutputStream(appletInstanceFile));){
                    this.kryo.writeClassAndObject(output, applet);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.updateAppletFiles();
    }

    @Override
    public void resetRuntime() {
        this.activateSimulatorRuntimeInstance();
        this.transientMemory.clearOnReset();
        this.updateAppletFiles();
        Iterator aids = this.applets.keySet().iterator();
        ArrayList<AID> aidsToTrash = new ArrayList<AID>();
        while (aids.hasNext()) {
            AID aid = (AID)aids.next();
            aidsToTrash.add(aid);
        }
        for (AID anAidsToTrash : aidsToTrash) {
            this.clearApplet(anAidsToTrash);
        }
        this.loadFiles.clear();
        this.generatedLoadFileAIDs.clear();
        Arrays.fill(this.responseBuffer, (byte)0);
        this.transactionDepth = 0;
        this.responseBufferSize = 0;
        this.currentAID = null;
        this.previousAID = null;
        this.transientMemory.forgetBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transmitCommand(byte[] command) throws SystemException {
        try {
            byte[] byArray = super.transmitCommand(command);
            return byArray;
        }
        finally {
            Applet applet = this.getApplet(this.getAID());
            if (this.appletsDir != null && applet != null) {
                this.updateAppletFile(this.getAID(), applet);
            }
        }
    }

    protected void clearApplet(AID aid) {
        this.activateSimulatorRuntimeInstance();
        SimulatorRuntime.ApplicationInstance applicationInstance = this.lookupApplet(aid);
        if (applicationInstance == null) {
            throw new SystemException(4);
        }
        this.applets.remove(aid);
        Applet applet = applicationInstance.getApplet();
        if (applet == null) {
            return;
        }
        if (this.getApplet(this.currentAID) == applet) {
            this.deselect(applicationInstance);
        }
    }

    @Override
    protected void deleteApplet(AID aid) {
        super.deleteApplet(aid);
        if (this.appletsDir != null) {
            File appletFile = new File(this.appletsDir, AIDUtil.toString(aid));
            appletFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deselect(SimulatorRuntime.ApplicationInstance applicationInstance) {
        try {
            super.deselect(applicationInstance);
        }
        finally {
            if (this.appletsDir != null && applicationInstance != null) {
                Applet applet = applicationInstance.getApplet();
                AID aid = applicationInstance.getAID();
                this.updateAppletFile(aid, applet);
            }
        }
    }

    private void updateAppletFile(AID aid, Applet applet) {
        try {
            File appletInstanceFile = new File(this.appletsDir, AIDUtil.toString(aid));
            if (!appletInstanceFile.isFile()) {
                throw new RuntimeException("Path " + appletInstanceFile.getAbsolutePath() + " doesn't exist");
            }
            try (Output output = new Output(new FileOutputStream(appletInstanceFile));){
                this.kryo.writeClassAndObject(output, applet);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void updateAppletFiles() {
        for (SimulatorRuntime.ApplicationInstance appInst : this.applets.values()) {
            Applet applet = appInst.getApplet();
            AID aid = appInst.getAID();
            this.updateAppletFile(aid, applet);
        }
    }
}

