/*
 * Decompiled with CFR 0.152.
 */
package de.ohmesoftware.javadoctoproperties;

import com.sun.javadoc.DocErrorReporter;
import com.sun.tools.doclets.standard.Standard;
import java.util.Arrays;

public class Options {
    public static final String PREFIX_OPTION = "-prefix";
    public static final String OUTPUT_OPTION = "-output";
    private static final String EMPTY = "";
    private String propertiesPrefix = "";
    private String output = "javadoc.properties";

    public static int optionLength(String option) {
        switch (option) {
            case "-prefix": 
            case "-output": {
                return 2;
            }
        }
        return Standard.optionLength((String)option);
    }

    public String getPropertiesPrefix() {
        return this.propertiesPrefix;
    }

    public boolean load(String[][] options, DocErrorReporter errorReporter) {
        if (options != null && options.length > 0) {
            String[] outputOption;
            String[] prefixOption = Arrays.stream(options).filter(s -> ((String[])s).length > 0 && s[0].equals(PREFIX_OPTION)).findFirst().orElse(null);
            if (prefixOption != null) {
                if (prefixOption.length != 2) {
                    errorReporter.printError(String.format("%s option can only take one argument as properties prefix.", PREFIX_OPTION));
                    return false;
                }
                this.propertiesPrefix = prefixOption[1];
            }
            if ((outputOption = (String[])Arrays.stream(options).filter(s -> ((String[])s).length > 0 && s[0].equals(OUTPUT_OPTION)).findFirst().orElse(null)) != null) {
                if (outputOption.length != 2) {
                    errorReporter.printError(String.format("%s option can only take one argument as output file.", OUTPUT_OPTION));
                    return false;
                }
                this.output = outputOption[1];
            }
        }
        return true;
    }

    public String getOutput() {
        return this.output;
    }
}

