/*
 * Decompiled with CFR 0.152.
 */
package de.ohmesoftware.javadoctoproperties;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import de.ohmesoftware.javadoctoproperties.Options;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Converter {
    private static final String EQUALS = "=";
    private static final String SPACE = " ";
    private static final String PROPERTY_SEPARATOR = ".";

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static int optionLength(String option) {
        return Options.optionLength(option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        Options _options = new Options();
        boolean optionsLoaded = _options.load(options, reporter);
        return optionsLoaded;
    }

    public static boolean start(RootDoc root) {
        Options options = new Options();
        boolean optionsLoaded = options.load(root.options(), (DocErrorReporter)root);
        if (!optionsLoaded) {
            return false;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String propertyPrefix = Converter.buildPrefix(options.getPropertiesPrefix());
        for (ClassDoc classDoc : root.classes()) {
            Converter.printProperty(printWriter, propertyPrefix, (ProgramElementDoc)classDoc);
            for (FieldDoc fieldDoc : classDoc.fields()) {
                Converter.printProperty(printWriter, propertyPrefix + Converter.buildPropertyName((ProgramElementDoc)classDoc), (ProgramElementDoc)fieldDoc);
            }
        }
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(options.getOutput()));){
            root.printNotice(String.format("Writing to %s", new File(options.getOutput()).getAbsolutePath()));
            outputStreamWriter.write(stringWriter.toString());
        }
        catch (IOException e) {
            root.printError(String.format("Could not write to properties file: %s", e.getMessage()));
            return false;
        }
        return true;
    }

    private static String buildPropertyName(ProgramElementDoc memberDoc) {
        return memberDoc.name().substring(0, 1).toLowerCase() + memberDoc.name().substring(1);
    }

    private static String buildPrefix(String propertiesPrefix) {
        if (!propertiesPrefix.endsWith(PROPERTY_SEPARATOR)) {
            propertiesPrefix = propertiesPrefix + PROPERTY_SEPARATOR;
        }
        return propertiesPrefix;
    }

    private static void printProperty(PrintWriter printWriter, String propertiesPrefix, ProgramElementDoc memberDoc) {
        printWriter.print(Converter.buildPrefix(propertiesPrefix));
        printWriter.print(Converter.buildPropertyName(memberDoc));
        printWriter.print(EQUALS);
        printWriter.println(Converter.cleanComment(memberDoc.commentText()));
    }

    private static String cleanComment(String comment) {
        return comment.replaceAll("\\n", SPACE).replaceAll("\\s+", SPACE);
    }
}

