/*
 * Decompiled with CFR 0.152.
 */
package de.ohmesoftware.javadoctoopenapischema;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.javadoc.Javadoc;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Enricher {
    private static final String SUMMARY = "No summary.";
    private static final String DESCRIPTION = "No description.";
    private static final Logger LOGGER = LoggerFactory.getLogger(Enricher.class);
    private static final String JAVA_EXT = ".java";
    private static final String DOT = ".";
    private static final String SLASH = "/";
    private static final String SCHEMA_ANNOTATION_SIMPLE_NAME = "Schema";
    private static final String SCHEMA_ANNOTATION_CLASS = "io.swagger.v3.oas.annotations.media.Schema";
    private static final String EMPTY_STRING = "";
    private static final String SPACE_STRING = " ";
    private static final String INCLUDE_EXCLUDE_SEPARATOR = ",";
    private static final String QUOTATION_MARK_STRING = "\"";
    private static final String SCHEMA_DESCRIPTION = "description";
    private static final String SCHEMA_TITLE = "title";
    private static final String SCHEMA_REQUIRED = "required";
    private static final String SCHEMA_MAX_LENGTH = "maxLength";
    private static final String SCHEMA_MIN_LENGTH = "minLength";
    private static final String SCHEMA_MAX = "maximum";
    private static final String SCHEMA_MIN = "minimum";
    private static final String GLOB = "glob:";
    private static final String PARAGRAPH_START = "<p>";
    private static final String PARAGRAPH_END = "</p>";
    private static final String LI_START = "\\n * ";
    private static final String LI_END = "";
    private static final String UL_START = "";
    private static final String UL_END = "";
    private static final String NOT_EMPTY_ANNOTATION = "javax.validation.constraints.NotEmpty";
    private static final String COLUMN_ANNOTATION = "javax.persistence.Column";
    private static final String COLUMN_LENGTH_PROP = "length";
    private static final String COLUMN_NULLABLE = "nullable";
    private static final String SIZE_ANNOTATION = "javax.validation.constraints.Size";
    private static final String NOT_NULL_ANNOTATION = "javax.validation.constraints.NotNull";
    private static final String MIN_ANNOTATION = "javax.validation.constraints.Min";
    private static final String MAX_ANNOTATION = "javax.validation.constraints.Max";
    private static final String VALUE_PROP = "value";
    private static final String SIZE_MIN_PROP = "min";
    private static final String SIZE_MAX_PROP = "max";
    private static final String EMBEDDABLE_ANNOTATION = "javax.persistence.Embeddable";
    private static final String EXCLUDES_OPT = "-excludes";
    private static final String INCLUDES_OPT = "-includes";
    private static final String SOURCE_OPT = "-sourcePath";
    private static final String HATEAOS_HAL_OPT = "-hateaosHAL";
    private static final String GET = "get";
    private static final String IS = "is";
    private String sourcePath;
    private Set<String> includes;
    private Set<String> excludes;
    private boolean hateaos;

    public Enricher(String sourcePath, Set<String> includes, Set<String> excludes, boolean hateaos) {
        this.sourcePath = sourcePath;
        this.includes = includes;
        this.excludes = excludes;
        this.hateaos = hateaos;
    }

    private static CompilationUnit parseFile(File file) {
        try {
            return JavaParser.parse((File)file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(String.format("Could not find file: %s", file), e);
        }
    }

    private static String getBaseSourcePath(CompilationUnit compilationUnit, String sourcePath) {
        if ((sourcePath = sourcePath.replace('\\', '/')).endsWith(JAVA_EXT)) {
            sourcePath = sourcePath.substring(0, sourcePath.lastIndexOf(47));
        }
        String _package = compilationUnit.getPackageDeclaration().map(p -> p.getName().asString()).orElse("");
        String packagePath = _package.replace(DOT, SLASH);
        int overlap = 0;
        for (int i = packagePath.length(); i >= 0; --i) {
            if (!sourcePath.endsWith(packagePath.substring(0, i))) continue;
            overlap = i;
            break;
        }
        return sourcePath.substring(0, sourcePath.length() - overlap);
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.err.println("No command line options passed.");
            System.exit(-1);
        }
        String sourcePath = Enricher.parseOption(args, SOURCE_OPT, true, null);
        String includes = Enricher.parseOption(args, INCLUDES_OPT, false, null);
        String excludes = Enricher.parseOption(args, EXCLUDES_OPT, false, null);
        boolean hateaos = Enricher.parseFlag(args, HATEAOS_HAL_OPT);
        Enricher enricher = new Enricher(sourcePath, includes == null ? null : Arrays.stream(includes.split(INCLUDE_EXCLUDE_SEPARATOR)).map(String::trim).collect(Collectors.toSet()), excludes == null ? null : Arrays.stream(excludes.split(INCLUDE_EXCLUDE_SEPARATOR)).map(String::trim).collect(Collectors.toSet()), hateaos);
        enricher.enrich();
    }

    private static boolean parseFlag(String[] args, String option) {
        Optional<String> optionArg = Arrays.stream(args).filter(s -> s.equals(option)).findFirst();
        return optionArg.isPresent();
    }

    private static String parseOption(String[] args, String option, boolean required, String _default) {
        Optional<String> optionArg = Arrays.stream(args).filter(s -> s.equals(option)).findFirst();
        if (!optionArg.isPresent() && required) {
            System.err.println(String.format("Required option '%s' is missing.", option));
            System.exit(-2);
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(option)) continue;
            if (args.length > i + 1) {
                return args[i + 1];
            }
            System.err.println(String.format("Required option argument for '%s' is missing.", option));
            System.exit(-2);
        }
        if (required) {
            System.err.println(String.format("Required option '%s' is missing.", option));
            System.exit(-2);
        }
        return _default;
    }

    public void enrich() {
        LOGGER.info(String.format("Enriching source path '%s'", this.sourcePath));
        try {
            Files.walkFileTree(Paths.get(this.sourcePath, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    LOGGER.debug(String.format("Checking file '%s' for inclusion / exclusion", path.getFileName().toString()));
                    if (Enricher.this.includes != null && !Enricher.this.includes.isEmpty()) {
                        boolean handle = false;
                        for (String include : Enricher.this.includes) {
                            PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(Enricher.GLOB + include);
                            if (!pathMatcher.matches(path) || !path.toFile().isFile()) continue;
                            LOGGER.debug(String.format("Included file: '%s'", path.getFileName().toString()));
                            handle = true;
                            break;
                        }
                        if (!handle) {
                            LOGGER.debug(String.format("Not included file: '%s'", path.getFileName().toString()));
                            return FileVisitResult.CONTINUE;
                        }
                    }
                    if (Enricher.this.excludes != null && !Enricher.this.excludes.isEmpty()) {
                        for (String exclude : Enricher.this.excludes) {
                            PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(Enricher.GLOB + exclude);
                            if (!pathMatcher.matches(path)) continue;
                            if (path.toFile().isDirectory()) {
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                            LOGGER.debug(String.format("Excluded file: '%s'", path.getFileName().toString()));
                            return FileVisitResult.CONTINUE;
                        }
                    }
                    Enricher.this.handleSchema(path);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    LOGGER.warn(String.format("Could not check file '%s'", file.getFileName().toString()));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Could not walk through source files.", (Throwable)e);
            throw new RuntimeException("Could not walk through source files.", e);
        }
    }

    private String getJavadocSummary(String javadoc) {
        String[] commentParts = javadoc.split(PARAGRAPH_START);
        return commentParts[0].trim();
    }

    private String getJavadocDescription(String javadoc) {
        String[] commentParts = javadoc.split(PARAGRAPH_START);
        if (commentParts.length > 1) {
            String description = commentParts[1].trim();
            if (description.endsWith(PARAGRAPH_START)) {
                description = description.substring(0, description.length() - PARAGRAPH_START.length());
            }
            if (description.endsWith(PARAGRAPH_END)) {
                description = description.substring(0, description.length() - PARAGRAPH_END.length());
            }
            return description;
        }
        return null;
    }

    private String getJavadoc(BodyDeclaration bodyDeclaration) {
        Javadoc javadoc = bodyDeclaration.getComment().filter(Comment::isJavadocComment).map(c -> c.asJavadocComment().parse()).orElse(null);
        if (javadoc != null) {
            return javadoc.getDescription().getElements().stream().map(d -> d.toText().trim()).collect(Collectors.joining(SPACE_STRING));
        }
        return null;
    }

    private void handleSchema(Path path) throws IOException {
        CompilationUnit compilationUnit;
        LOGGER.info(String.format("Handling file: '%s'", path.getFileName().toString()));
        try {
            compilationUnit = JavaParser.parse((File)path.toFile());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not find file.", e);
        }
        String basePath = Enricher.getBaseSourcePath(compilationUnit, path.toString());
        ArrayList classOrInterfaceDeclarations = new ArrayList(compilationUnit.findAll(ClassOrInterfaceDeclaration.class));
        for (ClassOrInterfaceDeclaration classOrInterfaceDeclaration : classOrInterfaceDeclarations) {
            this.addSchemaAnnotation(basePath, compilationUnit, (BodyDeclaration<?>)classOrInterfaceDeclaration);
            classOrInterfaceDeclaration.getFields().forEach(f -> this.addSchemaAnnotation(basePath, compilationUnit, (BodyDeclaration<?>)f));
            classOrInterfaceDeclaration.getMethods().stream().filter(m -> this.checkIfMethodIsGetter((MethodDeclaration)m) && !this.checkIfMethodIsForField((MethodDeclaration)m, classOrInterfaceDeclaration)).forEach(m -> this.addSchemaAnnotation(basePath, compilationUnit, (BodyDeclaration<?>)m));
            FileWriter fileWriter = new FileWriter(path.toFile());
            Throwable throwable = null;
            try {
                fileWriter.write(compilationUnit.toString());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileWriter == null) continue;
                if (throwable != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fileWriter.close();
            }
        }
    }

    private boolean checkIfMethodIsGetter(MethodDeclaration methodDeclaration) {
        String methodName = methodDeclaration.getNameAsString();
        if (methodName.startsWith(GET) && methodDeclaration.getParameters().isEmpty()) {
            return true;
        }
        return methodName.startsWith(IS) && methodDeclaration.getParameters().isEmpty() && methodDeclaration.getType().isPrimitiveType() && methodDeclaration.getType().asPrimitiveType().asString().equals("boolean");
    }

    private String getFieldNameForMethod(MethodDeclaration methodDeclaration) {
        String methodName = methodDeclaration.getNameAsString();
        String fieldName = null;
        if (methodName.startsWith(GET)) {
            fieldName = methodName.substring(GET.length());
        } else if (methodName.startsWith(IS)) {
            fieldName = methodName.substring(IS.length());
        }
        return fieldName;
    }

    private boolean checkIfMethodIsForField(MethodDeclaration methodDeclaration, ClassOrInterfaceDeclaration classOrInterfaceDeclaration) {
        String fieldName = this.getFieldNameForMethod(methodDeclaration);
        if (fieldName == null) {
            return true;
        }
        return classOrInterfaceDeclaration.getFieldByName(fieldName).isPresent();
    }

    private void setSchemaMemberValue(NormalAnnotationExpr annotationExpr, String schemaProperty, boolean value) {
        Optional<MemberValuePair> memberValuePairOptional = annotationExpr.getPairs().stream().filter(a -> a.getName().getIdentifier().equals(schemaProperty)).findFirst();
        if (!memberValuePairOptional.isPresent()) {
            annotationExpr.addPair(schemaProperty, (Expression)new BooleanLiteralExpr(value));
        } else {
            memberValuePairOptional.get().setValue((Expression)new BooleanLiteralExpr(value));
        }
    }

    private void setSchemaMemberValue(NormalAnnotationExpr annotationExpr, String schemaProperty, int value) {
        Optional<MemberValuePair> memberValuePairOptional = annotationExpr.getPairs().stream().filter(a -> a.getName().getIdentifier().equals(schemaProperty)).findFirst();
        if (!memberValuePairOptional.isPresent()) {
            annotationExpr.addPair(schemaProperty, (Expression)new IntegerLiteralExpr(value));
        } else {
            memberValuePairOptional.get().setValue((Expression)new IntegerLiteralExpr(value));
        }
    }

    private void setSchemaMemberValue(NormalAnnotationExpr annotationExpr, String schemaProperty, String value) {
        Optional<MemberValuePair> memberValuePairOptional = annotationExpr.getPairs().stream().filter(a -> a.getName().getIdentifier().equals(schemaProperty)).findFirst();
        if (!memberValuePairOptional.isPresent()) {
            if (value != null) {
                annotationExpr.addPair(schemaProperty, (Expression)new StringLiteralExpr(this.escapeString(value)));
            }
        } else if (value != null) {
            memberValuePairOptional.get().setValue((Expression)new StringLiteralExpr(this.escapeString(value)));
        }
    }

    private String getFullClassName(CompilationUnit compilationUnit, String className) {
        if (className.contains(DOT)) {
            return className;
        }
        switch (className) {
            case "String": 
            case "Long": 
            case "Integer": 
            case "Double": 
            case "Float": 
            case "Date": 
            case "Boolean": {
                return String.class.getPackage().getName() + DOT + className;
            }
        }
        return compilationUnit.getImports().stream().filter(i -> !i.isAsterisk() && i.getName().getIdentifier().equals(className)).map(i -> i.getName().asString()).findFirst().orElse(compilationUnit.getPackageDeclaration().map(p -> p.getName().asString() + DOT + className).orElseThrow(() -> new RuntimeException(String.format("Could not resolve import for type: %s", className))));
    }

    private String getFullClassName(CompilationUnit compilationUnit, ClassOrInterfaceType extent) {
        return this.getFullClassName(compilationUnit, extent.getNameAsString());
    }

    private File getSourceFile(String basePath, CompilationUnit compilationUnit, ClassOrInterfaceType extent) {
        String className = this.getFullClassName(compilationUnit, extent);
        String sourcePath = basePath + className.replace('.', '/') + JAVA_EXT;
        return new File(sourcePath);
    }

    protected TypeDeclaration parseClassOrInterfaceType(String basePath, CompilationUnit compilationUnit, ClassOrInterfaceType classOrInterfaceType) {
        CompilationUnit newCompilationUnit = Enricher.parseFile(this.getSourceFile(basePath, compilationUnit, classOrInterfaceType));
        return (TypeDeclaration)newCompilationUnit.findFirst(TypeDeclaration.class).orElseThrow(() -> new RuntimeException(String.format("Could not parse type: %s", classOrInterfaceType.asString())));
    }

    private boolean isEmbedded(String basePath, CompilationUnit compilationUnit, Type propertyClassOrInterfaceType) {
        if (!propertyClassOrInterfaceType.isClassOrInterfaceType()) {
            return false;
        }
        if (this.isPrimitive((Type)propertyClassOrInterfaceType.asClassOrInterfaceType())) {
            return false;
        }
        TypeDeclaration extendTypeDeclaration = this.parseClassOrInterfaceType(basePath, compilationUnit, propertyClassOrInterfaceType.asClassOrInterfaceType());
        return extendTypeDeclaration.isAnnotationPresent(EMBEDDABLE_ANNOTATION) || extendTypeDeclaration.isAnnotationPresent(this.getSimpleNameFromClass(EMBEDDABLE_ANNOTATION));
    }

    private boolean isEnumProperty(String basePath, CompilationUnit compilationUnit, Type propertyClassOrInterfaceType) {
        if (!propertyClassOrInterfaceType.isClassOrInterfaceType()) {
            return false;
        }
        TypeDeclaration extendTypeDeclaration = this.parseClassOrInterfaceType(basePath, compilationUnit, propertyClassOrInterfaceType.asClassOrInterfaceType());
        return extendTypeDeclaration.isEnumDeclaration();
    }

    private String getSimpleNameFromClass(String fqClassName) {
        String[] packages = fqClassName.split("\\.");
        return packages[packages.length - 1];
    }

    private boolean isPrimitive(Type type) {
        if (type.isPrimitiveType()) {
            return true;
        }
        if (type.isClassOrInterfaceType()) {
            switch (this.getSimpleNameFromClass(type.asClassOrInterfaceType().getName().asString())) {
                case "String": 
                case "Double": 
                case "Integer": 
                case "Blob": 
                case "Date": 
                case "Float": 
                case "Byte": 
                case "Short": 
                case "BigInteger": 
                case "BigDecimal": 
                case "Long": 
                case "Calendar": {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isSimpleType(String basePath, CompilationUnit compilationUnit, Type type) {
        if (type.isArrayType() || this.isCollection(type)) {
            return false;
        }
        if (this.isEmbedded(basePath, compilationUnit, type)) {
            return true;
        }
        if (this.isPrimitive(type)) {
            return true;
        }
        return this.isEnumProperty(basePath, compilationUnit, type);
    }

    private boolean isNotPrimitiveArray(String basePath, CompilationUnit compilationUnit, Type commonType, Type elementType) {
        return commonType.isArrayType() && elementType != null && !this.isEmbedded(basePath, compilationUnit, elementType) && !this.isSimpleType(basePath, compilationUnit, elementType);
    }

    private boolean isCollection(Type type) {
        if (type.isClassOrInterfaceType()) {
            switch (this.getSimpleNameFromClass(type.asClassOrInterfaceType().getName().asString())) {
                case "Set": 
                case "List": 
                case "Collection": {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isNotPrimitiveCollection(String basePath, CompilationUnit compilationUnit, Type commonType) {
        return this.isCollection(commonType) && commonType.isClassOrInterfaceType() && commonType.asClassOrInterfaceType().getTypeArguments().isPresent() && !this.isEmbedded(basePath, compilationUnit, (Type)((NodeList)commonType.asClassOrInterfaceType().getTypeArguments().get()).get(0)) && !this.isSimpleType(basePath, compilationUnit, (Type)((NodeList)commonType.asClassOrInterfaceType().getTypeArguments().get()).get(0));
    }

    private void addSchemaAnnotation(String basePath, CompilationUnit compilationUnit, BodyDeclaration<?> bodyDeclaration) {
        NormalAnnotationExpr schemaAnnotationExpr;
        String javadoc = this.getJavadoc(bodyDeclaration);
        String summary = SUMMARY;
        String description = DESCRIPTION;
        if (javadoc != null) {
            summary = this.getJavadocSummary(javadoc);
            description = this.getJavadocDescription(javadoc);
        }
        if (description == null) {
            description = summary;
        } else {
            String _description = summary;
            if (!summary.endsWith(DOT)) {
                _description = _description + DOT;
            }
            description = _description + SPACE_STRING + description;
        }
        Type commonType = null;
        Type elementType = null;
        String fieldname = null;
        if (bodyDeclaration.isFieldDeclaration()) {
            commonType = bodyDeclaration.asFieldDeclaration().getCommonType();
            fieldname = bodyDeclaration.asFieldDeclaration().getVariable(0).getNameAsString();
            elementType = bodyDeclaration.asFieldDeclaration().getElementType();
        }
        if (bodyDeclaration.isMethodDeclaration()) {
            commonType = bodyDeclaration.asMethodDeclaration().getType();
            fieldname = this.getFieldNameForMethod(bodyDeclaration.asMethodDeclaration());
            elementType = commonType.getElementType();
        }
        if (this.hateaos && (bodyDeclaration.isFieldDeclaration() || bodyDeclaration.isMethodDeclaration())) {
            boolean notPrimitiveArray = this.isNotPrimitiveArray(basePath, compilationUnit, commonType, elementType);
            boolean notPrimitiveCollection = this.isNotPrimitiveCollection(basePath, compilationUnit, commonType);
            if (notPrimitiveArray || notPrimitiveCollection || !this.isSimpleType(basePath, compilationUnit, commonType) && !commonType.isArrayType() && !this.isCollection(commonType)) {
                if (notPrimitiveArray || notPrimitiveCollection) {
                    summary = String.format("URIs to the resource associations: %s", summary);
                    description = String.format("For the resource creation with `POST` this attribute is an array of URIs to the associated resources. For a `GET` operation on the item or collection resource this attribute of the same name is included in the `_links` section as `\"_links\": { \"%s\": { \"href\": \"Resource URI\"} } ` section containing the URI to the associated collection of resources. The associated resources can be updated with a `PUT` call with `Content-Type: text/uri-list` and a list with URIs to the updated associated resources.", fieldname);
                } else {
                    summary = String.format("URI to the resource association: %s", summary);
                    description = String.format("For the resource creation with `POST` this attribute is an URI to the associated resource. For a `GET` operation on the item or collection resource this attribute of the same name is included in the `_links` section as `\"_links\": { \"%s\": { \"href\": \"Resource URI\"} } `. The associated resource can be updated with a `PUT` call with `Content-Type: text/uri-list` and the single URI to the updated associated resource.", fieldname);
                }
            }
        }
        if ((schemaAnnotationExpr = (NormalAnnotationExpr)bodyDeclaration.getAnnotationByName(SCHEMA_ANNOTATION_SIMPLE_NAME).map(Expression::asNormalAnnotationExpr).orElse(null)) == null) {
            schemaAnnotationExpr = bodyDeclaration.addAndGetAnnotation(SCHEMA_ANNOTATION_CLASS).asNormalAnnotationExpr();
        }
        this.setSchemaMemberValue(schemaAnnotationExpr, SCHEMA_TITLE, summary);
        if (bodyDeclaration.isFieldDeclaration() || bodyDeclaration.isMethodDeclaration()) {
            Expression value;
            boolean required = false;
            int maxSize = -1;
            int minSize = -1;
            int max = -1;
            int min = -1;
            AnnotationExpr annotationExpr = this.getAnnotation(bodyDeclaration, NOT_EMPTY_ANNOTATION);
            if (annotationExpr != null) {
                required = true;
                minSize = 1;
            }
            if ((annotationExpr = this.getAnnotation(bodyDeclaration, NOT_NULL_ANNOTATION)) != null) {
                required = true;
            }
            if ((annotationExpr = this.getAnnotation(bodyDeclaration, MIN_ANNOTATION)) != null && (value = this.getAnnotationValue(annotationExpr, VALUE_PROP)) != null) {
                min = value.asIntegerLiteralExpr().asInt();
            }
            if ((annotationExpr = this.getAnnotation(bodyDeclaration, MAX_ANNOTATION)) != null && (value = this.getAnnotationValue(annotationExpr, VALUE_PROP)) != null) {
                max = value.asIntegerLiteralExpr().asInt();
            }
            if ((annotationExpr = this.getAnnotation(bodyDeclaration, COLUMN_ANNOTATION)) != null) {
                Expression length;
                Expression nullable = this.getAnnotationValue(annotationExpr, COLUMN_NULLABLE);
                if (nullable != null) {
                    required = nullable.asBooleanLiteralExpr().getValue();
                }
                if ((length = this.getAnnotationValue(annotationExpr, COLUMN_LENGTH_PROP)) != null) {
                    maxSize = length.asIntegerLiteralExpr().asInt();
                }
            }
            if ((annotationExpr = this.getAnnotation(bodyDeclaration, SIZE_ANNOTATION)) != null) {
                value = this.getAnnotationValue(annotationExpr, SIZE_MIN_PROP);
                if (value != null) {
                    minSize = value.asIntegerLiteralExpr().asInt();
                }
                if ((value = this.getAnnotationValue(annotationExpr, SIZE_MAX_PROP)) != null && maxSize < 0) {
                    maxSize = value.asIntegerLiteralExpr().asInt();
                }
            }
            description = description + "";
            if (required) {
                description = description + "\\n * This value is required.";
                this.setSchemaMemberValue(schemaAnnotationExpr, SCHEMA_REQUIRED, required);
            }
            if (commonType.asString().endsWith(String.class.getSimpleName()) || commonType.asString().endsWith(Blob.class.getSimpleName()) || commonType.isArrayType()) {
                if (minSize > -1) {
                    description = description + String.format("\\n * The minimum length is %d.", minSize);
                    this.setSchemaMemberValue(schemaAnnotationExpr, SCHEMA_MIN_LENGTH, minSize);
                }
                if (maxSize > -1) {
                    description = description + String.format("\\n * The maximum length is %d.", maxSize);
                    this.setSchemaMemberValue(schemaAnnotationExpr, SCHEMA_MAX_LENGTH, maxSize);
                }
            }
            if (max > -1) {
                description = description + String.format("\\n * The maximum value is %d.", max);
                this.setSchemaMemberValue(schemaAnnotationExpr, SCHEMA_MAX, "" + max + "");
            }
            if (min > -1) {
                description = description + String.format("\\n * The minimum value is %d.", min);
                this.setSchemaMemberValue(schemaAnnotationExpr, SCHEMA_MIN, "" + min + "");
            }
            description = description.endsWith("") ? description.substring(0, description.length() - "".length()) : description + "";
        }
        this.setSchemaMemberValue(schemaAnnotationExpr, SCHEMA_DESCRIPTION, description);
    }

    private Expression getAnnotationValue(AnnotationExpr annotationExpr, String property) {
        if (annotationExpr.isNormalAnnotationExpr()) {
            NormalAnnotationExpr normalAnnotationExpr = annotationExpr.asNormalAnnotationExpr();
            for (MemberValuePair valuePair : normalAnnotationExpr.getPairs()) {
                if (!valuePair.getName().asString().equals(property)) continue;
                return valuePair.getValue();
            }
        } else if (annotationExpr.isSingleMemberAnnotationExpr()) {
            return annotationExpr.asSingleMemberAnnotationExpr().getMemberValue();
        }
        return null;
    }

    private AnnotationExpr getAnnotation(BodyDeclaration<?> bodyDeclaration, String annotationClass) {
        return bodyDeclaration.getAnnotationByName(annotationClass).orElse(bodyDeclaration.getAnnotationByName(annotationClass.substring(annotationClass.lastIndexOf(46) + 1)).orElse(null));
    }

    protected String quoteString(String string) {
        return QUOTATION_MARK_STRING + string + QUOTATION_MARK_STRING;
    }

    protected String escapeString(String string) {
        return string.trim().replace("\n", SPACE_STRING).replace("\r", "").replace("<", "&lt;").replace(">", "&gt;").replace(QUOTATION_MARK_STRING, "\\\"").replaceAll("\\s+", SPACE_STRING);
    }
}

