/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven.plugins.site;

import com.github.maven.plugins.core.GitHubProjectMojo;
import com.github.maven.plugins.core.PathUtils;
import com.github.maven.plugins.core.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.eclipse.egit.github.core.Blob;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.CommitUser;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Reference;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.Tree;
import org.eclipse.egit.github.core.TreeEntry;
import org.eclipse.egit.github.core.TypedResource;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.RequestException;
import org.eclipse.egit.github.core.service.DataService;
import org.eclipse.egit.github.core.service.UserService;
import org.eclipse.egit.github.core.util.EncodingUtils;

@Mojo(name="site")
public class SiteMojo
extends GitHubProjectMojo {
    public static final String NO_JEKYLL_FILE = ".nojekyll";
    @Parameter(defaultValue="refs/heads/gh-pages")
    private String branch;
    @Parameter
    private String path;
    @Parameter(required=true)
    private String message;
    @Parameter(property="github.site.repositoryName")
    private String repositoryName;
    @Parameter(property="github.site.repositoryOwner")
    private String repositoryOwner;
    @Parameter(property="github.site.userName", defaultValue="${github.global.userName}")
    private String userName;
    @Parameter(property="github.site.password", defaultValue="${github.global.password}")
    private String password;
    @Parameter(property="github.site.oauth2Token", defaultValue="${github.global.oauth2Token}")
    private String oauth2Token;
    @Parameter(property="github.site.host", defaultValue="${github.global.host}")
    private String host;
    @Parameter(property="github.site.server", defaultValue="${github.global.server}")
    private String server;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(property="siteOutputDirectory", defaultValue="${project.reporting.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${settings}", required=true, readonly=true)
    private Settings settings;
    @Parameter(property="github.site.force")
    private boolean force;
    @Parameter(property="github.site.noJekyll")
    private boolean noJekyll;
    @Parameter(property="github.site.merge")
    private boolean merge;
    @Parameter(property="github.site.dryRun")
    private boolean dryRun;
    @Parameter(property="github.site.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        Object[] paths;
        if (this.skip) {
            this.info("Github Site Plugin execution skipped");
            return;
        }
        RepositoryId repository = this.getRepository(this.project, this.repositoryOwner, this.repositoryName);
        if (this.dryRun) {
            this.info("Dry run mode, repository will not be modified");
        }
        String baseDir = this.outputDirectory.getAbsolutePath();
        Object[] includePaths = StringUtils.removeEmpties(this.includes);
        Object[] excludePaths = StringUtils.removeEmpties(this.excludes);
        if (this.isDebug()) {
            this.debug(MessageFormat.format("Scanning {0} and including {1} and exluding {2}", baseDir, Arrays.toString(includePaths), Arrays.toString(excludePaths)));
        }
        if ((paths = PathUtils.getMatchingPaths((String[])includePaths, (String[])excludePaths, baseDir)).length != 1) {
            this.info(MessageFormat.format("Creating {0} blobs", paths.length));
        } else {
            this.info("Creating 1 blob");
        }
        if (this.isDebug()) {
            this.debug(MessageFormat.format("Scanned files to include: {0}", Arrays.toString(paths)));
        }
        int capacity = 500;
        int start = 0;
        int end = Math.min(500, paths.length);
        while (start < paths.length) {
            this.info("Sending batch: [" + start + " - " + end + ")");
            String[] subpaths = SiteMojo.copyOfRange((String[])paths, start, end);
            this.doExecute(repository, subpaths);
            start = end;
            end = end + 500 < paths.length ? end + 500 : paths.length;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doExecute(RepositoryId repository, String[] subpaths) throws MojoExecutionException {
        Commit created;
        Tree tree;
        Object prefix;
        DataService service = new DataService(this.createClient(this.host, this.userName, this.password, this.oauth2Token, this.server, this.settings));
        ArrayList<TreeEntry> entries = new ArrayList<TreeEntry>(subpaths.length);
        Object object = prefix = this.path != null ? this.path : "";
        if (((String)prefix).length() > 0 && !((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        if ('\\' == File.separatorChar) {
            for (int i = 0; i < subpaths.length; ++i) {
                subpaths[i] = subpaths[i].replace('\\', '/');
            }
        }
        boolean createNoJekyll = this.noJekyll;
        for (String subpath : subpaths) {
            TreeEntry entry = new TreeEntry();
            entry.setPath((String)prefix + subpath);
            if (createNoJekyll && NO_JEKYLL_FILE.equals(entry.getPath())) {
                createNoJekyll = false;
            }
            entry.setType("blob");
            entry.setMode("100644");
            entry.setSha(this.createBlob(service, repository, subpath));
            entries.add(entry);
        }
        if (createNoJekyll) {
            TreeEntry entry = new TreeEntry();
            entry.setPath(NO_JEKYLL_FILE);
            entry.setType("blob");
            entry.setMode("100644");
            if (this.isDebug()) {
                this.debug("Creating empty .nojekyll blob at root of tree");
            }
            if (!this.dryRun) {
                try {
                    entry.setSha(service.createBlob((IRepositoryIdProvider)repository, new Blob().setEncoding("base64").setContent("")));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error creating .nojekyll empty blob: " + e.getMessage(), (Exception)e);
                }
            }
            entries.add(entry);
        }
        Reference ref = null;
        try {
            ref = service.getReference((IRepositoryIdProvider)repository, this.branch);
        }
        catch (RequestException e) {
            if (404 != e.getStatus()) {
                throw new MojoExecutionException("Error getting reference: " + e.getMessage(), (Exception)((Object)e));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error getting reference: " + e.getMessage(), (Exception)e);
        }
        if (ref != null && !"commit".equals(ref.getObject().getType())) {
            throw new MojoExecutionException(MessageFormat.format("Existing ref {0} points to a {1} ({2}) instead of a commmit", ref.getRef(), ref.getObject().getType(), ref.getObject().getSha()));
        }
        try {
            int size = entries.size();
            if (size != 1) {
                this.info(MessageFormat.format("Creating tree with {0} blob entries", size));
            } else {
                this.info("Creating tree with 1 blob entry");
            }
            String baseTree = null;
            if (this.merge && ref != null) {
                Tree currentTree = service.getCommit((IRepositoryIdProvider)repository, ref.getObject().getSha()).getTree();
                if (currentTree != null) {
                    baseTree = currentTree.getSha();
                }
                this.info(MessageFormat.format("Merging with tree {0}", baseTree));
            }
            tree = !this.dryRun ? service.createTree((IRepositoryIdProvider)repository, entries, baseTree) : new Tree();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating tree: " + e.getMessage(), (Exception)e);
        }
        Commit commit = new Commit();
        commit.setMessage(this.message);
        commit.setTree(tree);
        try {
            UserService userService = new UserService(service.getClient());
            User user = userService.getUser();
            CommitUser author = new CommitUser();
            author.setName(user.getName());
            author.setEmail(user.getEmail());
            author.setDate(new GregorianCalendar().getTime());
            commit.setAuthor(author);
            commit.setCommitter(author);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error retrieving user info: " + e.getMessage(), (Exception)e);
        }
        if (ref != null) {
            commit.setParents(Collections.singletonList(new Commit().setSha(ref.getObject().getSha())));
        }
        try {
            created = !this.dryRun ? service.createCommit((IRepositoryIdProvider)repository, commit) : new Commit();
            this.info(MessageFormat.format("Creating commit with SHA-1: {0}", created.getSha()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating commit: " + e.getMessage(), (Exception)e);
        }
        TypedResource object2 = new TypedResource();
        object2.setType("commit").setSha(created.getSha());
        if (ref != null) {
            ref.setObject(object2);
            try {
                this.info(MessageFormat.format("Updating reference {0} from {1} to {2}", this.branch, ((Commit)commit.getParents().get(0)).getSha(), created.getSha()));
                if (this.dryRun) return;
                service.editReference((IRepositoryIdProvider)repository, ref, this.force);
                return;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error editing reference: " + e.getMessage(), (Exception)e);
            }
        }
        ref = new Reference().setObject(object2).setRef(this.branch);
        try {
            this.info(MessageFormat.format("Creating reference {0} starting at commit {1}", this.branch, created.getSha()));
            if (this.dryRun) return;
            service.createReference((IRepositoryIdProvider)repository, ref);
            return;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating reference: " + e.getMessage(), (Exception)e);
        }
    }

    private String createBlob(DataService service, RepositoryId repository, String subpath) throws MojoExecutionException {
        File file = new File(this.outputDirectory, subpath);
        long length = file.length();
        int size = length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length;
        ByteArrayOutputStream output = new ByteArrayOutputStream(size);
        try (FileInputStream stream = new FileInputStream(file);){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = stream.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading file: " + e.getMessage(), (Exception)e);
        }
        Blob blob = new Blob().setEncoding("base64");
        String encoded = EncodingUtils.toBase64((byte[])output.toByteArray());
        blob.setContent(encoded);
        try {
            if (this.isDebug()) {
                this.debug(MessageFormat.format("Creating blob from {0}", file.getAbsolutePath()));
            }
            if (!this.dryRun) {
                return service.createBlob((IRepositoryIdProvider)repository, blob);
            }
            return null;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating blob: " + e.getMessage(), (Exception)e);
        }
    }

    private static String[] copyOfRange(String[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        String[] copy = new String[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }
}

