/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven.plugins.core;

import com.github.maven.plugins.core.egit.GitHubClientEgit;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.net.HttpURLConnection;

public class RateLimitedGitHubClient
extends GitHubClientEgit {
    private volatile RateLimiter rateLimiter;

    public RateLimitedGitHubClient() {
    }

    public RateLimitedGitHubClient(String hostname) {
        super(hostname);
    }

    public RateLimitedGitHubClient(String hostname, int port, String scheme) {
        super(hostname, port, scheme);
    }

    protected HttpURLConnection createPost(String uri) throws IOException {
        this.rateLimiter().acquire();
        return super.createPost(uri);
    }

    protected HttpURLConnection createPut(String uri) throws IOException {
        this.rateLimiter().acquire();
        return super.createPut(uri);
    }

    private RateLimiter rateLimiter() {
        if (this.rateLimiter != null) {
            return this.rateLimiter;
        }
        return this.initializeRateLimiter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized RateLimiter initializeRateLimiter() {
        if (this.rateLimiter != null) {
            return this.rateLimiter;
        }
        HttpURLConnection connection = null;
        try {
            connection = this.createGet("/rate_limit");
            int remaining = connection.getHeaderFieldInt("X-RateLimit-Remaining", -1);
            int reset = connection.getHeaderFieldInt("X-RateLimit-Reset", -1);
            int now = (int)(System.currentTimeMillis() / 1000L);
            RateLimiter rateLimiter = this.rateLimiter = RateLimiter.create((double)((double)remaining / (double)Math.max(reset - now, 1)));
            return rateLimiter;
        }
        catch (Exception e) {
            RateLimiter rateLimiter = this.rateLimiter = RateLimiter.create((double)0.3333333333333333);
            return rateLimiter;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

