/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.spring.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.modelmapper.Converter;
import org.modelmapper.MappingException;
import org.modelmapper.ModelMapper;
import org.modelmapper.Module;
import org.modelmapper.spi.ErrorMessage;
import org.modelmapper.spi.Mapping;
import org.modelmapper.spi.MappingContext;
import org.modelmapper.spring.data.AggregateIdentifierProcessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.support.DefaultRepositoryInvokerFactory;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.lang.Nullable;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;

public class AggregateMappingModule
implements Module {
    private final RepositoryInvokerFactory invokerFactory;
    private final Repositories repositories;
    private final ConversionService conversions;
    private final List<AggregateIdentifierProcessor> processors;
    private final List<Class<?>> exclusions;
    private final Map<Class<?>, NullHandling> nullHandling;
    private NullHandling defaultNullHandling;

    public AggregateMappingModule(Repositories repositories, ConversionService conversions) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)conversions, (String)"ConversionService must not be null!");
        this.invokerFactory = new DefaultRepositoryInvokerFactory(repositories);
        this.repositories = repositories;
        this.conversions = conversions;
        this.processors = new ArrayList<AggregateIdentifierProcessor>();
        this.exclusions = new ArrayList();
        this.nullHandling = new HashMap();
        this.defaultNullHandling = NullHandling.THROW_EXCEPTION;
    }

    public AggregateMappingModule register(AggregateIdentifierProcessor processor) {
        Assert.notNull((Object)processor, (String)"IdentifierProcessor must not be null!");
        this.processors.add(processor);
        return this;
    }

    public AggregateMappingModule exclude(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        this.exclusions.add(type);
        return this;
    }

    public AggregateMappingModule nullHandling(Class<?> type, NullHandling nullHandling) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.notNull((Object)((Object)nullHandling), (String)"NullHandling must not be null!");
        this.nullHandling.put(type, nullHandling);
        return this;
    }

    public AggregateMappingModule defaultNullHandling(NullHandling nullHandling) {
        Assert.notNull((Object)((Object)nullHandling), (String)"Null handling must not be null!");
        this.defaultNullHandling = nullHandling;
        return this;
    }

    public void setupModule(ModelMapper mapper) {
        final PluginRegistry registry = PluginRegistry.of(this.processors);
        Converter<Object, Object> converter = new Converter<Object, Object>(){

            @Nullable
            public Object convert(MappingContext<Object, Object> context) {
                Class destinationType = context.getDestinationType();
                PersistentEntity information = AggregateMappingModule.this.repositories.getPersistentEntity(destinationType);
                Object source = context.getSource();
                if (source == null) {
                    return this.handleNull(null, context);
                }
                Object identifier = registry.getPluginFor((Object)destinationType).map(it -> it.preProcessIdentifier(source, destinationType)).orElse(source);
                Object domainId = Arrays.asList(UUID.class, String.class).contains(identifier.getClass()) ? AggregateMappingModule.this.conversions.convert(identifier, information.getRequiredIdProperty().getType()) : source;
                RepositoryInvoker invoker = AggregateMappingModule.this.invokerFactory.getInvokerFor(destinationType);
                Object result = Optional.ofNullable(domainId).flatMap(it -> invoker.invokeFindById(it)).orElse(null);
                return result == null ? this.handleNull(domainId, context) : result;
            }

            @Nullable
            private Object handleNull(@Nullable Object id, MappingContext<?, ?> context) {
                Class destinationType = context.getDestinationType();
                NullHandling handling = Optional.ofNullable((NullHandling)((Object)AggregateMappingModule.this.nullHandling.get(destinationType))).orElse(AggregateMappingModule.this.defaultNullHandling);
                if (handling.equals((Object)NullHandling.THROW_EXCEPTION)) {
                    Class type = context.getParent().getSourceType();
                    boolean isCollection = Collection.class.isAssignableFrom(type);
                    MappingContext mappingContext = isCollection ? context.getParent() : context;
                    Mapping mapping = mappingContext.getMapping();
                    throw new AggregateReferenceMappingException(mapping.getPath(), id, destinationType);
                }
                return null;
            }
        };
        Converter<Object, Object> toStringOrUuidConverter = new Converter<Object, Object>(){

            @Nullable
            public Object convert(MappingContext<Object, Object> context) {
                Object source = context.getSource();
                Class sourceType = context.getSourceType();
                Class targetType = context.getDestinationType();
                Object id = AggregateMappingModule.this.repositories.getPersistentEntity(source.getClass()).getIdentifierAccessor(source).getRequiredIdentifier();
                Object processed = registry.getPluginFor((Object)sourceType).map(it -> it.postProcessIdentifier(id, sourceType, targetType)).orElse(id);
                return targetType.isInstance(processed) ? processed : AggregateMappingModule.this.conversions.convert(processed, targetType);
            }
        };
        this.repositories.forEach(arg_0 -> this.lambda$setupModule$1(registry, mapper, (Converter)converter, (Converter)toStringOrUuidConverter, arg_0));
    }

    private /* synthetic */ void lambda$setupModule$1(PluginRegistry registry, ModelMapper mapper, Converter converter, Converter toStringOrUuidConverter, Class type) {
        if (this.exclusions.stream().anyMatch(type::isAssignableFrom)) {
            return;
        }
        PersistentEntity information = this.repositories.getPersistentEntity(type);
        Class domainIdType = information.getRequiredIdProperty().getType();
        HashSet<Class> idTypes = new HashSet<Class>();
        idTypes.addAll(Arrays.asList(UUID.class, String.class));
        idTypes.add(domainIdType);
        registry.getPluginFor((Object)type).map(AggregateIdentifierProcessor::getAdditionalIdentifierTypes).ifPresent(idTypes::addAll);
        idTypes.forEach(it -> {
            mapper.addConverter(converter, it, information.getType());
            mapper.addConverter(toStringOrUuidConverter, information.getType(), it);
        });
    }

    public static enum NullHandling {
        RETURN_NULL,
        THROW_EXCEPTION;

    }

    public static class AggregateReferenceMappingException
    extends MappingException {
        private static final long serialVersionUID = 2554385939537893357L;
        private final String path;
        private final Object source;
        private final Class<?> targetType;
        private final String message;

        public AggregateReferenceMappingException(String path, @Nullable Object source, Class<?> targetType) {
            super(Arrays.asList(new ErrorMessage(AggregateReferenceMappingException.message(targetType, source))));
            this.path = AggregateReferenceMappingException.cleanUp(path);
            this.source = source;
            this.targetType = targetType;
            this.message = AggregateReferenceMappingException.message(targetType, source);
        }

        private static String message(Class<?> targetType, @Nullable Object source) {
            return String.format("Invalid %s reference %s!", targetType.getName(), source);
        }

        private static String cleanUp(String path) {
            return !path.contains(".") ? path : path.substring(0, path.indexOf(46));
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public Object getSource() {
            return this.source;
        }

        @Generated
        public Class<?> getTargetType() {
            return this.targetType;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }
    }
}

